/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class ThatchBedBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Helpers.translatable("tfc.tile_entity.thatch_bed");
    private BlockState headState;
    private BlockState footState;

    public ThatchBedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.THATCH_BED.get(), pos, state, ThatchBedBlockEntity.defaultInventory(1), NAME);
        this.headState = this.footState = Blocks.f_50016_.m_49966_();
    }

    public void setBed(BlockState head, BlockState foot, ItemStack top) {
        assert (this.f_58857_ != null);
        this.headState = head;
        this.footState = foot;
        ((ItemStackHandler)this.inventory).setStackInSlot(0, top);
    }

    public void destroyBed() {
        this.ejectInventory();
        this.invalidateCapabilities();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Helpers.dropWithContext(serverLevel, this.headState, this.f_58858_, ctx -> {}, true);
            Helpers.dropWithContext(serverLevel, this.footState, this.f_58858_, ctx -> {}, true);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("HeadBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.headState));
        tag.m_128365_("FootBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.footState));
        super.m_183515_(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag) {
        this.headState = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("HeadBlockState"));
        this.footState = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("FootBlockState"));
        super.loadAdditional(tag);
    }
}

