/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.InventoryWrapper;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.PestContainer;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TFCChestBlockEntity
extends ChestBlockEntity
implements PestContainer,
ISlotCallback {
    @Nullable
    private LazyOptional<IItemHandler> inventoryHandler = null;

    public static boolean isValid(ItemStack stack) {
        return ItemSizeManager.get(stack).getSize(stack).isEqualOrSmallerThan((Size)((Object)TFCConfig.SERVER.chestMaximumItemSize.get()));
    }

    public TFCChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TFCChestBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.CHEST.get(), pos, state);
    }

    public int m_6643_() {
        return 18;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x2.get(), id, inventory, (Container)this, 2);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return TFCChestBlockEntity.isValid(stack);
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.invalidateInventoryHandler();
    }

    public void invalidateCaps() {
        this.invalidateInventoryHandler();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.getCapability(cap, null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.ITEM) {
            return this.getInventoryHandler().cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return TFCChestBlockEntity.isValid(stack);
    }

    private void invalidateInventoryHandler() {
        if (this.inventoryHandler != null) {
            this.inventoryHandler.invalidate();
            this.inventoryHandler = null;
        }
    }

    private LazyOptional<IItemHandler> getInventoryHandler() {
        if (this.inventoryHandler != null) {
            return this.inventoryHandler;
        }
        assert (this.f_58857_ != null);
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof ChestBlock)) {
            return LazyOptional.empty();
        }
        ChestBlock chest = (ChestBlock)block;
        @Nullable Object chestContainer = ChestBlock.m_51511_((ChestBlock)chest, (BlockState)state, (Level)this.f_58857_, (BlockPos)this.m_58899_(), (boolean)true);
        if (chestContainer == null) {
            chestContainer = this;
        }
        InventoryWrapper itemHandler = new InventoryWrapper((Container)chestContainer, this);
        this.inventoryHandler = LazyOptional.of(() -> itemHandler);
        return this.inventoryHandler;
    }
}

