/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.LampFuel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LampBlockEntity
extends TickCounterBlockEntity
implements FluidTankCallback {
    protected FluidTank tank;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public LampBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.LAMP.get(), pos, state);
        this.tank = new InventoryFluidTank((Integer)TFCConfig.SERVER.lampCapacity.get(), stack -> LampFuel.get(stack.getFluid(), this.m_58900_()) != null, this);
    }

    @Override
    public void fluidTankChanged() {
        this.markForSync();
    }

    @Nullable
    public LampFuel getFuel() {
        assert (this.f_58857_ != null);
        return LampFuel.get(this.tank.getFluid().getFluid(), this.f_58857_.m_8055_(this.m_58899_()));
    }

    public boolean checkHasRanOut() {
        int usage;
        assert (this.f_58857_ != null);
        LampFuel fuel = this.getFuel();
        boolean ranOut = false;
        if (fuel != null && (usage = Mth.m_14107_((double)((double)this.getTicksSinceUpdate() / (double)fuel.getBurnRate()))) >= 1) {
            FluidStack used = this.tank.drain(usage, IFluidHandler.FluidAction.EXECUTE);
            if (this.tank.isEmpty() || used.getAmount() < usage) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(false)));
                ranOut = true;
            }
            this.resetCounter();
        }
        this.markForSync();
        return ranOut;
    }

    @Override
    public void loadAdditional(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("tank"));
        super.loadAdditional(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        super.m_183515_(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.FLUID) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }
}

