/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.container.GrillContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class GrillBlockEntity
extends AbstractFirepitBlockEntity<ItemStackHandler> {
    public static final int SLOT_EXTRA_INPUT_START = 4;
    public static final int SLOT_EXTRA_INPUT_END = 8;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.grill");
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[5];

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.GRILL.get(), pos, state, GrillBlockEntity.defaultInventory(9), NAME);
        if (((Boolean)TFCConfig.SERVER.firePitEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(3).extract(4, 5, 6, 7, 8), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).insert(4, 5, 6, 7, 8), Direction.UP);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInv, Player player) {
        return GrillContainer.create(this, playerInv, windowID);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot >= 4 && slot <= 8) {
            return Helpers.mightHaveCapability(stack, HeatCapability.CAPABILITY);
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    protected void handleCooking() {
        int slot = 4;
        while (slot <= 8) {
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            int finalSlot = slot++;
            inputStack.getCapability(HeatCapability.CAPABILITY, null).ifPresent(cap -> {
                HeatCapability.addTemp(cap, this.temperature);
                HeatingRecipe recipe = this.cachedRecipes[finalSlot - 4];
                if (recipe != null && recipe.isValidTemperature(cap.getTemperature())) {
                    ItemStack output = recipe.assemble(new ItemStackInventory(inputStack));
                    FoodCapability.applyTrait(output, FoodTraits.WOOD_GRILLED);
                    ((ItemStackHandler)this.inventory).setStackInSlot(finalSlot, output);
                    this.markForSync();
                }
            });
        }
    }

    @Override
    protected void coolInstantly() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            stack.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> cap.setTemperature(0.0f));
        }
    }

    @Override
    protected void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        for (int slot = 4; slot <= 8; ++slot) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            this.cachedRecipes[slot - 4] = stack.m_41619_() ? null : HeatingRecipe.getRecipe(new ItemStackInventory(stack));
        }
    }
}

