/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.common.blockentities.IFarmland;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FarmlandBlockEntity
extends TFCBlockEntity
implements IFarmland {
    private float nitrogen = 0.0f;
    private float phosphorous = 0.0f;
    private float potassium = 0.0f;

    public FarmlandBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.FARMLAND.get(), pos, state);
    }

    protected FarmlandBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.loadNutrients(nbt);
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        this.saveNutrients(nbt);
        super.m_183515_(nbt);
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, List<Component> text, boolean includeHydration, boolean includeNutrients) {
        if (includeHydration) {
            int value = FarmlandBlock.getHydration((LevelAccessor)level, pos);
            TranslatableComponent hydration = Helpers.translatable("tfc.tooltip.farmland.hydration", value);
            text.add((Component)hydration);
        }
        if (includeNutrients) {
            this.addTooltipInfo(text);
        }
    }

    @Override
    public float getNutrient(NutrientType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NutrientType.NITROGEN -> this.nitrogen;
            case NutrientType.PHOSPHOROUS -> this.phosphorous;
            case NutrientType.POTASSIUM -> this.potassium;
        };
    }

    @Override
    public void setNutrient(NutrientType type, float value) {
        this.setNutrientWithoutSync(type, value);
        this.markForSync();
    }

    @Override
    public void addNutrients(Fertilizer fertilizer) {
        this.setNutrientWithoutSync(NutrientType.NITROGEN, this.getNutrient(NutrientType.NITROGEN) + fertilizer.getNitrogen());
        this.setNutrientWithoutSync(NutrientType.PHOSPHOROUS, this.getNutrient(NutrientType.PHOSPHOROUS) + fertilizer.getPhosphorus());
        this.setNutrientWithoutSync(NutrientType.POTASSIUM, this.getNutrient(NutrientType.POTASSIUM) + fertilizer.getPotassium());
        this.markForSync();
    }

    private void setNutrientWithoutSync(NutrientType type, float value) {
        value = Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
        switch (type) {
            case NITROGEN: {
                this.nitrogen = value;
                break;
            }
            case PHOSPHOROUS: {
                this.phosphorous = value;
                break;
            }
            case POTASSIUM: {
                this.potassium = value;
            }
        }
    }

    public static enum NutrientType {
        NITROGEN,
        PHOSPHOROUS,
        POTASSIUM;

        public static final NutrientType[] VALUES;

        static {
            VALUES = NutrientType.values();
        }
    }
}

