/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ComposterBlockEntity
extends TickCounterBlockEntity {
    public static final int MAX_AMOUNT = 16;
    private int green;
    private int brown;

    public ComposterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.COMPOSTER.get(), pos, state);
    }

    public ComposterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void randomTick() {
        assert (this.f_58857_ != null);
        if (this.green >= 16 && this.brown >= 16 & !this.isRotten() && this.getTicksSinceUpdate() > this.getReadyTicks()) {
            this.setState(TFCComposterBlock.CompostType.READY);
            this.markForSync();
        }
        if (this.isRotten()) {
            Helpers.tickInfestation(this.f_58857_, this.m_58899_(), 5, null);
        }
    }

    public long getReadyTicks() {
        assert (this.f_58857_ != null);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.m_122190_((Vec3i)this.m_58899_());
        float rainfall = Climate.getRainfall(this.f_58857_, (BlockPos)cursor);
        long readyTicks = ((Integer)TFCConfig.SERVER.composterTicks.get()).intValue();
        if (((Boolean)TFCConfig.SERVER.composterRainfallCheck.get()).booleanValue()) {
            if (rainfall < 150.0f) {
                readyTicks *= (long)((150.0f - rainfall) / 50.0f + 1.0f);
            } else if (rainfall > 350.0f) {
                readyTicks *= (long)((rainfall - 350.0f) / 50.0f + 1.0f);
            }
        }
        cursor.m_122184_(0, 1, 0);
        if (Helpers.isBlock(this.f_58857_.m_8055_((BlockPos)cursor), TFCTags.Blocks.SNOW)) {
            readyTicks = (long)((float)readyTicks * 0.9f);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.m_122159_((Vec3i)this.m_58899_(), direction);
            if (!(this.f_58857_.m_8055_((BlockPos)cursor).m_60734_() instanceof TFCComposterBlock)) continue;
            readyTicks = (long)((float)readyTicks * 1.05f);
        }
        return readyTicks;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.green = nbt.m_128451_("green");
        this.brown = nbt.m_128451_("brown");
        if (!nbt.m_128425_("legacyFixed", 1)) {
            this.green = Mth.m_14045_((int)(this.green * 4), (int)0, (int)16);
            this.brown = Mth.m_14045_((int)(this.brown * 4), (int)0, (int)16);
        }
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("green", this.getGreen());
        nbt.m_128405_("brown", this.getBrown());
        nbt.m_128379_("legacyFixed", true);
        super.m_183515_(nbt);
    }

    public InteractionResult use(ItemStack stack, Player player, boolean client) {
        assert (this.f_58857_ != null);
        boolean rotten = this.isRotten();
        BlockPos pos = this.m_58899_();
        if (player.m_142538_().equals((Object)pos)) {
            return InteractionResult.FAIL;
        }
        Compost compost = this.getCompost(stack);
        if (stack.m_41619_() && player.m_6144_()) {
            if (this.brown == 16 && this.green == 16) {
                if (this.isReady()) {
                    Helpers.spawnItem(this.f_58857_, pos.m_7494_(), new ItemStack((ItemLike)TFCItems.COMPOST.get()));
                } else if (rotten) {
                    Helpers.spawnItem(this.f_58857_, pos.m_7494_(), new ItemStack((ItemLike)TFCItems.ROTTEN_COMPOST.get()));
                }
            }
            this.reset();
            Helpers.playSound(this.f_58857_, pos, SoundEvents.f_144206_);
            return this.finishUse(client);
        }
        if (rotten) {
            if (!client) {
                player.m_5661_((Component)Helpers.translatable("tfc.composter.rotten"), true);
            }
            return this.finishUse(client);
        }
        if (compost.type == AdditionType.POISON) {
            if (!client) {
                this.setState(TFCComposterBlock.CompostType.ROTTEN);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            Helpers.playSound(this.f_58857_, pos, SoundEvents.f_11955_);
            return this.finishUse(client);
        }
        if (this.green <= 16 && compost.type == AdditionType.GREEN) {
            if (this.green == 16) {
                if (!client) {
                    player.m_5661_((Component)Helpers.translatable("tfc.composter.too_many_greens"), true);
                }
            } else {
                this.green = Math.min(this.green + compost.amount, 16);
                if (!client) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    Helpers.playSound(this.f_58857_, pos, SoundEvents.f_11955_);
                    this.resetCounter();
                }
            }
            return this.finishUse(client);
        }
        if (this.brown <= 16 && compost.type == AdditionType.BROWN) {
            if (this.brown == 16) {
                if (!client) {
                    player.m_5661_((Component)Helpers.translatable("tfc.composter.too_many_browns"), true);
                }
            } else {
                this.brown = Math.min(this.brown + compost.amount, 16);
                if (!client) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    Helpers.playSound(this.f_58857_, pos, SoundEvents.f_11955_);
                    this.resetCounter();
                }
            }
            return this.finishUse(client);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult finishUse(boolean client) {
        if (!client) {
            int stage = (this.green + this.brown) / 4;
            if (this.green + this.brown > 0) {
                stage = Math.max(stage, 1);
            }
            this.setState(stage);
            this.markForSync();
        }
        return InteractionResult.m_19078_((boolean)client);
    }

    public int getGreen() {
        return this.green;
    }

    public int getBrown() {
        return this.brown;
    }

    public void reset() {
        this.brown = 0;
        this.green = 0;
        this.resetCounter();
        this.setState(TFCComposterBlock.CompostType.NORMAL, 0);
    }

    public boolean isRotten() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(this.m_58899_()).m_61143_(TFCComposterBlock.TYPE) == TFCComposterBlock.CompostType.ROTTEN;
    }

    public boolean isReady() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(this.m_58899_()).m_61143_(TFCComposterBlock.TYPE) == TFCComposterBlock.CompostType.READY;
    }

    public void setState(TFCComposterBlock.CompostType type) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_(TFCComposterBlock.TYPE, (Comparable)((Object)type)));
    }

    public void setState(TFCComposterBlock.CompostType type, int stage) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_(TFCComposterBlock.TYPE, (Comparable)((Object)type))).m_61124_((Property)TFCComposterBlock.STAGE, (Comparable)Integer.valueOf(stage)));
    }

    public void setState(int stage) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)TFCComposterBlock.STAGE, (Comparable)Integer.valueOf(stage)));
    }

    public Compost getCompost(ItemStack stack) {
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_POISONS)) {
            return new Compost(AdditionType.POISON, 0);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_BROWNS_LOW)) {
            return new Compost(AdditionType.BROWN, 1);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_BROWNS)) {
            return new Compost(AdditionType.BROWN, 2);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_BROWNS_HIGH)) {
            return new Compost(AdditionType.BROWN, 4);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_GREENS_LOW)) {
            return new Compost(AdditionType.GREEN, 1);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_GREENS)) {
            return new Compost(AdditionType.GREEN, 2);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_GREENS_HIGH)) {
            return new Compost(AdditionType.GREEN, 4);
        }
        return new Compost(AdditionType.NONE, 0);
    }

    public record Compost(AdditionType type, int amount) {
    }

    public static enum AdditionType {
        NONE,
        GREEN,
        BROWN,
        POISON;

    }
}

