/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IntArrayBuilder;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class AbstractFirepitBlockEntity<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>>
extends TickableInventoryBlockEntity<C>
implements ICalendarTickable,
MenuProvider {
    public static final int SLOT_FUEL_CONSUME = 0;
    public static final int SLOT_FUEL_INPUT = 3;
    protected final ContainerData syncableData;
    protected boolean needsSlotUpdate = false;
    protected boolean needsRecipeUpdate = false;
    protected int burnTicks = 0;
    protected int airTicks;
    protected float burnTemperature = 0.0f;
    protected float temperature = 0.0f;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private float dirtiness = 0.0f;

    public static void convertTo(LevelAccessor level, BlockPos pos, BlockState state, AbstractFirepitBlockEntity<?> firepit, Block newBlock) {
        firepit.ejectMainInventory();
        NonNullList<ItemStack> saved = Helpers.extractAllItems(firepit.inventory);
        level.m_7731_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)FirepitBlock.LIT, (Comparable)((Boolean)state.m_61143_((Property)FirepitBlock.LIT))), 3);
        BlockEntity newEntity = level.m_7702_(pos);
        if (newEntity instanceof AbstractFirepitBlockEntity) {
            AbstractFirepitBlockEntity newFirepit = (AbstractFirepitBlockEntity)newEntity;
            Helpers.insertAllItems(newFirepit.inventory, saved);
            newFirepit.copyFrom(firepit);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractFirepitBlockEntity<?> firepit) {
        firepit.checkForLastTickSync();
        firepit.checkForCalendarUpdate();
        if (firepit.needsRecipeUpdate) {
            firepit.needsRecipeUpdate = false;
            firepit.updateCachedRecipe();
        }
        if (level.m_46467_() % 20L == 0L) {
            AABB bounds = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)pos.m_123342_() + 0.5, (double)(pos.m_123343_() + 1));
            Helpers.gatherAndConsumeItems(level, bounds, (IItemHandler)firepit.inventory, 0, 3);
            firepit.updateSmokeLevel(state);
        }
        boolean isRaining = level.m_46758_(pos);
        if (((Boolean)state.m_61143_((Property)FirepitBlock.LIT)).booleanValue()) {
            if (firepit.burnTicks > 0) {
                firepit.burnTicks = firepit.burnTicks - (firepit.airTicks > 0 || isRaining ? 2 : 1);
            }
            if (firepit.burnTicks <= 0 && !firepit.consumeFuel()) {
                firepit.extinguish(state);
            }
        }
        if (firepit.airTicks > 0) {
            --firepit.airTicks;
        }
        if (firepit.temperature > 0.0f || firepit.burnTemperature > 0.0f) {
            firepit.temperature = HeatCapability.adjustDeviceTemp(firepit.temperature, firepit.burnTemperature, firepit.airTicks, isRaining);
        }
        HeatCapability.provideHeatTo(level, pos.m_7494_(), firepit.temperature);
        firepit.handleCooking();
        if (firepit.needsSlotUpdate) {
            firepit.cascadeFuelSlots();
        }
    }

    public AbstractFirepitBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<C> inventoryFactory, Component defaultName) {
        super(type, pos, state, inventoryFactory, defaultName);
        this.syncableData = new IntArrayBuilder().add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.temperature = nbt.m_128457_("temperature");
        this.burnTicks = nbt.m_128451_("burnTicks");
        this.airTicks = nbt.m_128451_("airTicks");
        this.burnTemperature = nbt.m_128457_("burnTemperature");
        this.lastPlayerTick = nbt.m_128454_("lastPlayerTick");
        this.dirtiness = nbt.m_128457_("dirtiness");
        this.needsRecipeUpdate = true;
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("temperature", this.temperature);
        nbt.m_128405_("burnTicks", this.burnTicks);
        nbt.m_128405_("airTicks", this.airTicks);
        nbt.m_128350_("burnTemperature", this.burnTemperature);
        nbt.m_128356_("lastPlayerTick", this.lastPlayerTick);
        nbt.m_128350_("dirtiness", this.dirtiness);
        super.m_183515_(nbt);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsSlotUpdate = true;
        this.updateCachedRecipe();
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        if (((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)FirepitBlock.LIT)).booleanValue()) {
            HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.inventory, this.burnTicks, this.burnTemperature, 0, 3);
            this.burnTicks = remainder.burnTicks();
            this.burnTemperature = remainder.burnTemperature();
            this.needsSlotUpdate = true;
            if (remainder.ticks() > 0L) {
                this.extinguish(this.f_58857_.m_8055_(this.f_58858_));
                this.coolInstantly();
            }
        }
    }

    @Override
    @Deprecated
    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    public void updateSmokeLevel(BlockState state) {
        assert (this.f_58857_ != null);
        this.dirtiness = Mth.m_14036_((float)(0.99f * this.dirtiness), (float)0.0f, (float)1.0f);
        int wantedSmokeLevel = Mth.m_14167_((float)Mth.m_184637_((float)this.dirtiness, (float)0.0f, (float)1.0f, (float)0.0f, (float)4.0f));
        if (state.m_61138_((Property)FirepitBlock.SMOKE_LEVEL) && (Integer)state.m_61143_((Property)FirepitBlock.SMOKE_LEVEL) != wantedSmokeLevel) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FirepitBlock.SMOKE_LEVEL, (Comparable)Integer.valueOf(wantedSmokeLevel)));
        }
    }

    public void intakeAir(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    public void extinguish(BlockState state) {
        assert (this.f_58857_ != null);
        if (((Boolean)state.m_61143_((Property)FirepitBlock.LIT)).booleanValue()) {
            Helpers.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11937_);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FirepitBlock.LIT, (Comparable)Boolean.valueOf(false)));
            this.burnTicks = 0;
            this.airTicks = 0;
            this.burnTemperature = 0.0f;
            this.dirtiness = 0.0f;
        }
    }

    public boolean light(BlockState state) {
        assert (this.f_58857_ != null);
        if (this.consumeFuel()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FirepitBlock.LIT, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    public void ejectMainInventory() {
        assert (this.f_58857_ != null);
        for (int i = 4; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = Helpers.removeStack((IItemHandler)this.inventory, i);
            if (stack.m_41619_()) continue;
            Helpers.spawnItem(this.f_58857_, this.f_58858_, stack, 0.7);
        }
    }

    public void copyFrom(AbstractFirepitBlockEntity<?> other) {
        this.burnTicks = other.burnTicks;
        this.airTicks = other.airTicks;
        this.burnTemperature = other.burnTemperature;
        this.temperature = other.temperature;
        this.needsSlotUpdate = true;
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return slot == 5 || slot == 6 ? 64 : 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 3 -> {
                if (Fuel.get(stack) != null && Helpers.isItem(stack.m_41720_(), TFCTags.Items.FIREPIT_FUEL)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> Helpers.mightHaveCapability(stack, HeatCapability.CAPABILITY);
            case 5, 6 -> true;
            default -> false;
        };
    }

    public float getTemperature() {
        return this.temperature;
    }

    public ContainerData getSyncableData() {
        return this.syncableData;
    }

    protected boolean consumeFuel() {
        ItemStack fuelStack = this.inventory.getStackInSlot(0);
        if (!fuelStack.m_41619_()) {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            this.needsSlotUpdate = true;
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.getDuration();
                this.burnTemperature = fuel.getTemperature();
                this.dirtiness += 1.0f - fuel.getPurity();
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    protected abstract void handleCooking();

    protected abstract void coolInstantly();

    protected abstract void updateCachedRecipe();

    protected void cascadeFuelSlots() {
        int lowestOpenSlot = 0;
        for (int i = 0; i <= 3; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (i > lowestOpenSlot) {
                this.inventory.setStackInSlot(lowestOpenSlot, stack.m_41777_());
                this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            }
            ++lowestOpenSlot;
        }
        this.needsSlotUpdate = false;
    }
}

