/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ToolTier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.Nullable;

public final class TFCTiers {
    public static final Tier IGNEOUS_INTRUSIVE = TFCTiers.register("igneous_intrusive", (Tier)Tiers.WOOD, (Tier)Tiers.STONE, TFCTags.Blocks.NEEDS_STONE_TOOL, 0, 60, 4.7f, 2.0f, 5);
    public static final Tier IGNEOUS_EXTRUSIVE = TFCTiers.register("igneous_extrusive", (Tier)Tiers.WOOD, (Tier)Tiers.STONE, TFCTags.Blocks.NEEDS_STONE_TOOL, 0, 70, 4.7f, 2.0f, 5);
    public static final Tier SEDIMENTARY = TFCTiers.register("sedimentary", (Tier)Tiers.WOOD, (Tier)Tiers.STONE, TFCTags.Blocks.NEEDS_STONE_TOOL, 0, 50, 4.0f, 2.0f, 5);
    public static final Tier METAMORPHIC = TFCTiers.register("metamorphic", (Tier)Tiers.WOOD, (Tier)Tiers.STONE, TFCTags.Blocks.NEEDS_STONE_TOOL, 0, 55, 4.35f, 2.0f, 5);
    public static final Tier COPPER = TFCTiers.register("copper", (Tier)Tiers.STONE, (Tier)Tiers.IRON, TFCTags.Blocks.NEEDS_COPPER_TOOL, 1, 600, 5.25f, 3.25f, 8);
    public static final Tier BRONZE = TFCTiers.register("bronze", (Tier)Tiers.IRON, (Tier)Tiers.DIAMOND, TFCTags.Blocks.NEEDS_BRONZE_TOOL, 2, 1300, 7.3f, 4.0f, 13);
    public static final Tier BISMUTH_BRONZE = TFCTiers.register("bismuth_bronze", (Tier)Tiers.IRON, (Tier)Tiers.DIAMOND, TFCTags.Blocks.NEEDS_BRONZE_TOOL, 2, 1200, 6.65f, 4.0f, 10);
    public static final Tier BLACK_BRONZE = TFCTiers.register("black_bronze", (Tier)Tiers.IRON, (Tier)Tiers.DIAMOND, TFCTags.Blocks.NEEDS_BRONZE_TOOL, 2, 1460, 6.0f, 4.25f, 10);
    public static final Tier WROUGHT_IRON = TFCTiers.register("wrought_iron", List.of(BRONZE, BISMUTH_BRONZE, BLACK_BRONZE, Tiers.IRON), List.of(Tiers.DIAMOND), TFCTags.Blocks.NEEDS_WROUGHT_IRON_TOOL, 3, 2200, 8.0f, 4.75f, 12);
    public static final Tier STEEL = TFCTiers.register("steel", (Tier)Tiers.DIAMOND, (Tier)Tiers.NETHERITE, TFCTags.Blocks.NEEDS_STEEL_TOOL, 4, 3300, 9.5f, 5.75f, 12);
    public static final Tier BLACK_STEEL = TFCTiers.register("black_steel", STEEL, (Tier)Tiers.NETHERITE, TFCTags.Blocks.NEEDS_BLACK_STEEL_TOOL, 5, 4200, 11.0f, 7.0f, 17);
    public static final Tier BLUE_STEEL = TFCTiers.register("blue_steel", (Tier)Tiers.NETHERITE, null, TFCTags.Blocks.NEEDS_COLORED_STEEL_TOOL, 6, 6500, 12.0f, 9.0f, 22);
    public static final Tier RED_STEEL = TFCTiers.register("red_steel", (Tier)Tiers.NETHERITE, null, TFCTags.Blocks.NEEDS_COLORED_STEEL_TOOL, 6, 6500, 12.0f, 9.0f, 22);

    private static Tier register(String name, Tier before, @Nullable Tier after, TagKey<Block> tag, int level, int uses, float speed, float damage, int enchantmentValue) {
        return TFCTiers.register(name, List.of(before), after == null ? List.of() : List.of(after), tag, level, uses, speed, damage, enchantmentValue);
    }

    private static Tier register(String name, List<Object> before, List<Object> after, TagKey<Block> tag, int level, int uses, float speed, float damage, int enchantmentValue) {
        ToolTier tier = new ToolTier(name, level, uses, speed, damage, enchantmentValue, tag, () -> Ingredient.f_43901_);
        if (!Helpers.BOOTSTRAP_ENVIRONMENT) {
            TierSortingRegistry.registerTier((Tier)tier, (ResourceLocation)Helpers.identifier(name), before, after);
        }
        return tier;
    }
}

