/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.container.BlastFurnaceContainer;
import net.dries007.tfc.config.HeatTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class BlastFurnaceScreen
extends BlockEntityScreen<BlastFurnaceBlockEntity, BlastFurnaceContainer> {
    private static final ResourceLocation BLAST_FURNACE = Helpers.identifier("textures/gui/blast_furnace.png");

    public BlastFurnaceScreen(BlastFurnaceContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BLAST_FURNACE);
        this.f_97731_ += 20;
        this.f_97727_ += 20;
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluid;
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int capacity = ((BlastFurnaceBlockEntity)this.blockEntity).getCapacity();
        int fuelCount = ((BlastFurnaceBlockEntity)this.blockEntity).getFuelCount();
        int inputCount = ((BlastFurnaceBlockEntity)this.blockEntity).getInputCount();
        int maximumCapacity = (Integer)TFCConfig.SERVER.blastFurnaceCapacity.get() * (Integer)TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get();
        boolean lit = (Boolean)((BlastFurnaceBlockEntity)this.blockEntity).m_58900_().m_61143_((Property)BlastFurnaceBlock.LIT);
        this.renderCapacityLimitedFillMeter(poseStack, 42, 22, lit ? 216 : 226, maximumCapacity, capacity, inputCount);
        this.renderCapacityLimitedFillMeter(poseStack, 124, 22, 206, maximumCapacity, capacity, fuelCount);
        int temperature = (int)(51.0f * ((BlastFurnaceBlockEntity)this.blockEntity).getTemperature() / Heat.maxVisibleTemperature());
        if (temperature > 0) {
            this.m_93228_(poseStack, this.f_97735_ + 8, this.f_97736_ + 76 - Math.min(51, temperature), 176, 0, 15, 5);
        }
        if (!(fluid = ((BlastFurnaceBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).map(c -> c.getFluidInTank(0)).orElse(FluidStack.EMPTY)).isEmpty()) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(fluid);
            int fillHeight = (int)Math.ceil(31.0f * (float)fluid.getAmount() / (float)((Integer)TFCConfig.SERVER.blastFurnaceFluidCapacity.get()).intValue());
            RenderHelpers.fillAreaWithSprite(poseStack, sprite, this.f_97735_ + 70, this.f_97736_ + 84 - fillHeight, 36, fillHeight, 16, 16);
        }
        this.resetToBackgroundSprite();
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        MutableComponent text;
        super.m_7025_(poseStack, mouseX, mouseY);
        int capacity = ((BlastFurnaceBlockEntity)this.blockEntity).getCapacity();
        int fuelCount = ((BlastFurnaceBlockEntity)this.blockEntity).getFuelCount();
        int inputCount = ((BlastFurnaceBlockEntity)this.blockEntity).getInputCount();
        FluidStack fluid = ((BlastFurnaceBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).map(c -> c.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (RenderHelpers.isInside(mouseX, mouseY, this.f_97735_ + 42, this.f_97736_ + 22, 10, 66)) {
            this.m_96602_(poseStack, (Component)Helpers.translatable("tfc.tooltip.blast_furnace_ore", inputCount, capacity), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.f_97735_ + 124, this.f_97736_ + 22, 10, 66)) {
            this.m_96602_(poseStack, (Component)Helpers.translatable("tfc.tooltip.blast_furnace_fuel", fuelCount, capacity), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.f_97735_ + 70, this.f_97736_ + 54, 36, 31) && !fluid.isEmpty()) {
            this.m_96602_(poseStack, (Component)Tooltips.fluidUnitsOf(fluid), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.f_97735_ + 8, this.f_97736_ + 76 - 51, 15, 51) && (text = ((HeatTooltipStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(((BlastFurnaceBlockEntity)this.blockEntity).getTemperature())) != null) {
            this.m_96602_(poseStack, (Component)text, mouseX, mouseY);
        }
    }

    private void renderCapacityLimitedFillMeter(PoseStack poseStack, int x, int y, int fillU, int maximum, int capacity, int content) {
        if (capacity == 0) {
            this.m_93228_(poseStack, this.f_97735_ + x, this.f_97736_ + y, 246, 0, 10, 66);
        } else if (content == 0) {
            int emptyHeight = 64 * capacity / maximum;
            this.m_93228_(poseStack, this.f_97735_ + x, this.f_97736_ + y + 64 - emptyHeight, 236, 0, 10, 1 + emptyHeight);
        } else {
            int emptyHeight = 64 * capacity / maximum;
            int fillHeight = 64 * content / maximum;
            this.m_93228_(poseStack, this.f_97735_ + x, this.f_97736_ + y + 64 - emptyHeight, 236, 0, 10, 1 + emptyHeight - fillHeight);
            this.m_93228_(poseStack, this.f_97735_ + x, this.f_97736_ + y + 65 - fillHeight, fillU, 1, 10, fillHeight);
        }
    }
}

