/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.minecraft.Util;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.HorseMarkingLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Variant;

public class TFCHorseRenderer
extends AbstractHorseRenderer<Horse, HorseModel<Horse>> {
    private static final Map<Variant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(Variant.class), map -> {
        map.put(Variant.WHITE, new ResourceLocation("textures/entity/horse/horse_white.png"));
        map.put(Variant.CREAMY, new ResourceLocation("textures/entity/horse/horse_creamy.png"));
        map.put(Variant.CHESTNUT, new ResourceLocation("textures/entity/horse/horse_chestnut.png"));
        map.put(Variant.BROWN, new ResourceLocation("textures/entity/horse/horse_brown.png"));
        map.put(Variant.BLACK, new ResourceLocation("textures/entity/horse/horse_black.png"));
        map.put(Variant.GRAY, new ResourceLocation("textures/entity/horse/horse_gray.png"));
        map.put(Variant.DARKBROWN, new ResourceLocation("textures/entity/horse/horse_darkbrown.png"));
    });

    public TFCHorseRenderer(EntityRendererProvider.Context context) {
        super(context, new HorseModel(context.m_174023_(ModelLayers.f_171186_)), 1.1f);
        this.m_115326_((RenderLayer)new HorseMarkingLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new HorseArmorLayer((RenderLayerParent)this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(Horse horse) {
        return LOCATION_BY_VARIANT.get(horse.m_30723_());
    }

    protected void scale(Horse horse, PoseStack poseStack, float ticks) {
        if (horse instanceof TFCAnimalProperties) {
            TFCAnimalProperties animal = (TFCAnimalProperties)horse;
            float scale = animal.getAgeScale();
            poseStack.m_85841_(scale, scale, scale);
        }
        super.m_7546_((AbstractHorse)horse, poseStack, ticks);
    }
}

