/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blocks.TFCBellBlock;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BellBlockEntity;

public class TFCBellBlockEntityRenderer
extends BellRenderer {
    private final Map<ResourceLocation, Material> materials = new HashMap<ResourceLocation, Material>();
    private final ModelPart bellBody;

    public TFCBellBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart part = ctx.m_173582_(RenderHelpers.modelIdentifier("bell_body"));
        this.bellBody = part.m_171324_("bell_body");
    }

    public void m_6922_(BellBlockEntity bell, float partialTick, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        Block block = bell.m_58900_().m_60734_();
        if (block instanceof TFCBellBlock) {
            TFCBellBlock bellBlock = (TFCBellBlock)block;
            float ticks = (float)bell.f_58813_ + partialTick;
            float xRot = 0.0f;
            float zRot = 0.0f;
            if (bell.f_58814_) {
                float swing = Mth.m_14031_((float)(ticks / (float)Math.PI)) / (4.0f + ticks / 3.0f);
                if (bell.f_58815_ == Direction.NORTH) {
                    xRot = -swing;
                } else if (bell.f_58815_ == Direction.SOUTH) {
                    xRot = swing;
                } else if (bell.f_58815_ == Direction.EAST) {
                    zRot = -swing;
                } else if (bell.f_58815_ == Direction.WEST) {
                    zRot = swing;
                }
            }
            this.bellBody.f_104203_ = xRot;
            this.bellBody.f_104205_ = zRot;
            Material mat = this.materials.computeIfAbsent(bellBlock.getTextureLocation(), res -> new Material(RenderHelpers.BLOCKS_ATLAS, res));
            VertexConsumer buffer = mat.m_119194_(buffers, RenderType::m_110446_);
            this.bellBody.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        }
    }
}

