/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class PotBlockEntityRenderer
implements BlockEntityRenderer<PotBlockEntity> {
    public void render(PotBlockEntity pot, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (pot.m_58904_() == null) {
            return;
        }
        PotRecipe.Output output = pot.getOutput();
        boolean useDefaultFluid = output != null && output.getFluidColor() != -1;
        FluidStack fluidStack = pot.getCapability(Capabilities.FLUID).map(cap -> cap.getFluidInTank(0)).filter(f -> !f.isEmpty()).orElseGet(() -> useDefaultFluid ? new FluidStack((Fluid)Fluids.f_76193_, 1000) : FluidStack.EMPTY);
        if (!fluidStack.isEmpty()) {
            int color = useDefaultFluid ? output.getFluidColor() : RenderHelpers.getFluidColor(fluidStack);
            RenderHelpers.renderFluidFace(poseStack, fluidStack, buffer, color, 0.3125f, 0.3125f, 0.6875f, 0.6875f, 0.625f, combinedOverlay, combinedLight);
        }
        pot.getCapability(Capabilities.ITEM).ifPresent(cap -> {
            int ordinal = 0;
            for (int slot = 4; slot <= 8; ++slot) {
                ItemStack item = cap.getStackInSlot(slot);
                if (item.m_41619_()) continue;
                float yOffset = 0.46f;
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 0.003125 + (double)yOffset, 0.5);
                poseStack.m_85841_(0.3f, 0.3f, 0.3f);
                poseStack.m_85845_(RenderHelpers.rotateDegreesX(90.0f));
                poseStack.m_85845_(RenderHelpers.rotateDegreesZ(180.0f));
                poseStack.m_85837_(0.0, 0.0, (double)(-0.12f * (float)(++ordinal)));
                Minecraft.m_91087_().m_91291_().m_174269_(item, ItemTransforms.TransformType.FIXED, combinedLight, combinedOverlay, poseStack, buffer, 0);
                poseStack.m_85849_();
            }
        });
    }
}

