/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.animation;

import com.mojang.math.Vector3f;
import net.dries007.tfc.client.model.animation.Keyframe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public record AnimationChannel(Target target, Keyframe[] keyframes) {

    public static interface Target {
        public void apply(ModelPart var1, Vector3f var2);
    }

    public static class Interpolations {
        public static final Interpolation LINEAR = (pos, lerp, frames, startIndex, endIndex, scale) -> {
            Vector3f start = frames[startIndex].target();
            Vector3f end = frames[endIndex].target();
            pos.m_122245_(Mth.m_14179_((float)lerp, (float)start.m_122239_(), (float)end.m_122239_()) * scale, Mth.m_14179_((float)lerp, (float)start.m_122260_(), (float)end.m_122260_()) * scale, Mth.m_14179_((float)lerp, (float)start.m_122269_(), (float)end.m_122269_()) * scale);
            return pos;
        };
        public static final Interpolation CATMULLROM = (pos, lerp, frames, startIndex, endIndex, scale) -> {
            Vector3f lowAnchor = frames[Math.max(0, startIndex - 1)].target();
            Vector3f start = frames[startIndex].target();
            Vector3f end = frames[endIndex].target();
            Vector3f highAnchor = frames[Math.min(frames.length - 1, endIndex + 1)].target();
            pos.m_122245_(Helpers.catMullRomSpline(lerp, lowAnchor.m_122239_(), start.m_122239_(), end.m_122239_(), highAnchor.m_122239_()) * scale, Helpers.catMullRomSpline(lerp, lowAnchor.m_122260_(), start.m_122260_(), end.m_122260_(), highAnchor.m_122260_()) * scale, Helpers.catMullRomSpline(lerp, lowAnchor.m_122269_(), start.m_122269_(), end.m_122269_(), highAnchor.m_122269_()) * scale);
            return pos;
        };
    }

    public static interface Interpolation {
        public Vector3f apply(Vector3f var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }

    public static class Targets {
        public static final Target POSITION = (part, pose) -> {
            part.f_104200_ += pose.m_122239_();
            part.f_104201_ += pose.m_122260_();
            part.f_104202_ += pose.m_122269_();
        };
        public static final Target ROTATION = (part, pose) -> {
            part.f_104203_ += pose.m_122239_();
            part.f_104204_ += pose.m_122260_();
            part.f_104205_ += pose.m_122269_();
        };
    }
}

