/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.function.ToIntFunction;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.calendar.Season;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public final class TFCColors {
    public static final ResourceLocation SKY_COLORS_LOCATION = Helpers.identifier("textures/colormap/sky.png");
    public static final ResourceLocation FOG_COLORS_LOCATION = Helpers.identifier("textures/colormap/fog.png");
    public static final ResourceLocation WATER_COLORS_LOCATION = Helpers.identifier("textures/colormap/water.png");
    public static final ResourceLocation WATER_FOG_COLORS_LOCATION = Helpers.identifier("textures/colormap/water_fog.png");
    public static final ResourceLocation FOLIAGE_COLORS_LOCATION = Helpers.identifier("textures/colormap/foliage.png");
    public static final ResourceLocation FOLIAGE_FALL_COLORS_LOCATION = Helpers.identifier("textures/colormap/foliage_fall.png");
    public static final ResourceLocation FOLIAGE_WINTER_COLORS_LOCATION = Helpers.identifier("textures/colormap/foliage_winter.png");
    public static final ResourceLocation GRASS_COLORS_LOCATION = Helpers.identifier("textures/colormap/grass.png");
    public static final ResourceLocation TALL_GRASS_COLORS_LOCATION = Helpers.identifier("textures/colormap/tall_grass.png");
    public static final ColorResolver FRESH_WATER;
    public static final ColorResolver SALT_WATER;
    private static final int COLORMAP_SIZE = 65536;
    private static final int COLORMAP_MASK = 65535;
    private static int[] SKY_COLORS_CACHE;
    private static int[] FOG_COLORS_CACHE;
    private static int[] WATER_COLORS_CACHE;
    private static int[] WATER_FOG_COLORS_CACHE;
    private static int[] FOLIAGE_COLORS_CACHE;
    private static int[] FOLIAGE_FALL_COLORS_CACHE;
    private static int[] FOLIAGE_WINTER_COLORS_CACHE;
    private static int[] GRASS_COLORS_CACHE;
    private static int[] TALL_GRASS_COLORS_CACHE;

    public static void setSkyColors(int[] skyColors) {
        SKY_COLORS_CACHE = skyColors;
    }

    public static void setFogColors(int[] fogColors) {
        FOG_COLORS_CACHE = fogColors;
    }

    public static void setWaterColors(int[] waterColors) {
        WATER_COLORS_CACHE = waterColors;
    }

    public static void setWaterFogColors(int[] waterFogColors) {
        WATER_FOG_COLORS_CACHE = waterFogColors;
    }

    public static void setFoliageColors(int[] foliageColorsCache) {
        FOLIAGE_COLORS_CACHE = foliageColorsCache;
    }

    public static void setFoliageFallColors(int[] foliageFallColorsCache) {
        FOLIAGE_FALL_COLORS_CACHE = foliageFallColorsCache;
    }

    public static void setFoliageWinterColors(int[] foliageWinterColorsCache) {
        FOLIAGE_WINTER_COLORS_CACHE = foliageWinterColorsCache;
    }

    public static void setGrassColors(int[] grassColorsCache) {
        GRASS_COLORS_CACHE = grassColorsCache;
    }

    public static void setTallGrassColors(int[] tallGrassColorsCache) {
        TALL_GRASS_COLORS_CACHE = tallGrassColorsCache;
    }

    public static int getSkyColor(CommonLevelAccessor level, Biome biome, BlockPos pos) {
        return TFCBiomes.hasExtension(level, biome) ? TFCColors.getClimateColor(SKY_COLORS_CACHE, pos) : biome.m_47463_();
    }

    public static int getFogColor(CommonLevelAccessor level, Biome biome, BlockPos pos) {
        return TFCBiomes.hasExtension(level, biome) ? TFCColors.getClimateColor(FOG_COLORS_CACHE, pos) : biome.m_47539_();
    }

    public static int getWaterColor(@Nullable BlockPos pos) {
        return pos != null ? TFCColors.getClimateColor(WATER_COLORS_CACHE, pos) : -1;
    }

    public static int getWaterFogColor(CommonLevelAccessor level, Biome biome, BlockPos pos) {
        return TFCBiomes.hasExtension(level, biome) ? TFCColors.getClimateColor(WATER_FOG_COLORS_CACHE, pos) : biome.m_47561_();
    }

    public static int getSeasonalFoliageColor(@Nullable BlockPos pos, int tintIndex) {
        if (pos != null && tintIndex == 0) {
            switch (TFCColors.getAdjustedNoisySeason(pos)) {
                case SPRING: 
                case SUMMER: {
                    return TFCColors.getClimateColor(FOLIAGE_COLORS_CACHE, pos);
                }
                case FALL: {
                    int index = Helpers.hash(91273491823412341L, pos);
                    return FOLIAGE_FALL_COLORS_CACHE[index & 0xFFFF];
                }
                case WINTER: {
                    return TFCColors.getClimateColor(FOLIAGE_WINTER_COLORS_CACHE, pos);
                }
            }
        }
        return -1;
    }

    public static int getFoliageColor(@Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            if (pos != null) {
                return TFCColors.getClimateColor(FOLIAGE_COLORS_CACHE, pos);
            }
            return TFCColors.getClimateColor(FOLIAGE_COLORS_CACHE, 10.0f, 250.0f);
        }
        return -1;
    }

    public static int getGrassColor(@Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            if (pos != null) {
                return TFCColors.getClimateColor(GRASS_COLORS_CACHE, pos);
            }
            return TFCColors.getClimateColor(GRASS_COLORS_CACHE, 10.0f, 250.0f);
        }
        return -1;
    }

    public static int getTallGrassColor(@Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            if (pos != null) {
                return TFCColors.getClimateColor(TALL_GRASS_COLORS_CACHE, pos);
            }
            return TFCColors.getClimateColor(TALL_GRASS_COLORS_CACHE, 10.0f, 250.0f);
        }
        return -1;
    }

    private static Season getAdjustedNoisySeason(BlockPos pos) {
        Month currentMonth = Calendars.CLIENT.getCalendarMonthOfYear();
        Season season = currentMonth.getSeason();
        float seasonDelta = 0.0f;
        float monthDelta = Calendars.CLIENT.getCalendarFractionOfMonth();
        switch (currentMonth) {
            case FEBRUARY: 
            case MAY: 
            case AUGUST: 
            case NOVEMBER: {
                seasonDelta = 0.5f * monthDelta;
                break;
            }
            case MARCH: 
            case JUNE: 
            case SEPTEMBER: 
            case DECEMBER: {
                season = season.previous();
                seasonDelta = 0.5f + 0.5f * monthDelta;
            }
        }
        int positionDeltaHash = Helpers.hash(836494186029734123L, pos) & 0xFF;
        if ((float)positionDeltaHash < 256.0f * seasonDelta) {
            season = season.next();
        }
        return season;
    }

    private static int getClimateColor(int[] colorCache, BlockPos pos) {
        Level level = ClientHelpers.getLevel();
        if (level != null) {
            float temperature = Climate.getTemperature(level, pos);
            float rainfall = Climate.getRainfall(level, pos);
            return TFCColors.getClimateColor(colorCache, temperature, rainfall);
        }
        return 0;
    }

    private static int getClimateColor(int[] colorCache, float temperature, float rainfall) {
        int temperatureIndex = 255 - Mth.m_14045_((int)((int)((temperature + 30.0f) * 255.0f / 60.0f)), (int)0, (int)255);
        int rainfallIndex = 255 - Mth.m_14045_((int)((int)(rainfall * 255.0f / 500.0f)), (int)0, (int)255);
        return colorCache[temperatureIndex | rainfallIndex << 8];
    }

    private static ColorResolver waterColorResolver(ToIntFunction<BlockPos> colorAccessor) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        return (biome, x, z) -> {
            cursor.m_122169_(x, 63.0, z);
            return colorAccessor.applyAsInt((BlockPos)cursor);
        };
    }

    static {
        SKY_COLORS_CACHE = new int[65536];
        FOG_COLORS_CACHE = new int[65536];
        WATER_COLORS_CACHE = new int[65536];
        WATER_FOG_COLORS_CACHE = new int[65536];
        FOLIAGE_COLORS_CACHE = new int[65536];
        FOLIAGE_FALL_COLORS_CACHE = new int[65536];
        FOLIAGE_WINTER_COLORS_CACHE = new int[65536];
        GRASS_COLORS_CACHE = new int[65536];
        TALL_GRASS_COLORS_CACHE = new int[65536];
        FRESH_WATER = TFCColors.waterColorResolver(TFCColors::getWaterColor);
        SALT_WATER = TFCColors.waterColorResolver(TFCColors::getWaterColor);
    }
}

