/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.create;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.create.ItemApplicationRecipeJS;
import dev.latvian.mods.kubejs.create.ProcessingRecipeJS;
import dev.latvian.mods.kubejs.create.SequencedAssemblyItemBuilder;
import dev.latvian.mods.kubejs.create.SequencedAssemblyRecipeJS;
import dev.latvian.mods.kubejs.create.events.BoilerHeaterHandlerEvent;
import dev.latvian.mods.kubejs.create.events.SpecialFluidHandlerEvent;
import dev.latvian.mods.kubejs.create.events.SpecialSpoutHandlerEvent;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class KubeJSCreatePlugin
extends KubeJSPlugin {
    private static final Map<ResourceLocation, Supplier<RecipeJS>> recipeProviders = Map.of(new ResourceLocation("create:deploying"), ItemApplicationRecipeJS::new, new ResourceLocation("create:item_application"), ItemApplicationRecipeJS::new);

    public void init() {
        RegistryObjectBuilderTypes.ITEM.addType("create:sequenced_assembly", SequencedAssemblyItemBuilder.class, SequencedAssemblyItemBuilder::new);
    }

    public void afterInit() {
        new SpecialSpoutHandlerEvent().post(ScriptType.STARTUP, "create.spout.special");
        new SpecialFluidHandlerEvent().post(ScriptType.STARTUP, "create.pipe.fluid_effect");
        new BoilerHeaterHandlerEvent().post(ScriptType.STARTUP, "create.boiler.heater");
    }

    public void addRecipes(RegisterRecipeHandlersEvent event) {
        event.register(new ResourceLocation("create:sequenced_assembly"), SequencedAssemblyRecipeJS::new);
        event.registerShaped(new ResourceLocation("create:mechanical_crafting"));
        for (AllRecipeTypes createRecipeType : AllRecipeTypes.values()) {
            if (!(createRecipeType.getSerializer() instanceof ProcessingRecipeSerializer)) continue;
            event.register(createRecipeType.getId(), recipeProviders.getOrDefault(createRecipeType.getId(), ProcessingRecipeJS::new));
        }
    }
}

