/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T>
implements Comparable<ConfigValue<T>> {
    public static final TextComponent NULL_TEXT = new TextComponent("null");
    public ConfigGroup group;
    public T value;
    public Consumer<T> setter;
    public T defaultValue;
    public String id = "";
    private int order = 0;
    private String nameKey = "";
    private Icon icon = Icons.SETTINGS;
    private boolean canEdit = true;

    public ConfigValue<T> init(ConfigGroup g, String i, @Nullable T v, Consumer<T> c, @Nullable T def) {
        this.group = g;
        this.id = i;
        this.value = v == null ? null : this.copy(v);
        this.setter = c;
        this.defaultValue = def;
        this.order = g.getValues().size();
        return this;
    }

    public final boolean setCurrentValue(@Nullable T v) {
        if (!this.isEqual(this.value, v)) {
            this.value = v;
            return true;
        }
        return false;
    }

    public boolean isEqual(@Nullable T v1, @Nullable T v2) {
        return Objects.equals(v1, v2);
    }

    public T copy(T value) {
        return value;
    }

    public Color4I getColor(@Nullable T v) {
        return Color4I.GRAY;
    }

    public void addInfo(TooltipList list) {
        list.add(ConfigValue.info("Default", this.getStringForGUI(this.defaultValue)));
    }

    protected static Component info(String key) {
        return new TextComponent(key + ":").m_130940_(ChatFormatting.AQUA);
    }

    public static Component info(String key, Object value) {
        Component c = value instanceof Component ? (Component)value : new TextComponent(String.valueOf(value));
        return new TextComponent("").m_7220_((Component)new TextComponent(key + ": ").m_130940_(ChatFormatting.AQUA)).m_7220_(c);
    }

    public abstract void onClicked(MouseButton var1, ConfigCallback var2);

    public Component getStringForGUI(@Nullable T v) {
        return new TextComponent(String.valueOf(v));
    }

    public String getPath() {
        String p = this.group.getPath();
        return p.isEmpty() ? this.id : p + "." + this.id;
    }

    public String getNameKey() {
        return this.nameKey.isEmpty() ? this.getPath() : this.nameKey;
    }

    public ConfigValue<T> setNameKey(String key) {
        this.nameKey = key;
        return this;
    }

    public String getName() {
        return I18n.m_118938_((String)this.getNameKey(), (Object[])new Object[0]);
    }

    public String getTooltip() {
        String k = this.getNameKey() + ".tooltip";
        return I18n.m_118936_((String)k) ? I18n.m_118938_((String)k, (Object[])new Object[0]) : "";
    }

    public ConfigValue<T> setOrder(int o) {
        this.order = o;
        return this;
    }

    public ConfigValue<T> setCanEdit(boolean e) {
        this.canEdit = e;
        return this;
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public ConfigValue<T> setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon(@Nullable T v) {
        return this.icon;
    }

    @Override
    public int compareTo(ConfigValue<T> o) {
        int i = this.group.getPath().compareToIgnoreCase(o.group.getPath());
        if (i == 0) {
            i = Integer.compare(this.order, o.order);
        }
        return i;
    }
}

