/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InscriberRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<InscriberRecipe> {
    public static final InscriberRecipeSerializer INSTANCE = new InscriberRecipeSerializer();

    private InscriberRecipeSerializer() {
    }

    private static InscriberProcessType getMode(JsonObject json) {
        String mode;
        return switch (mode = GsonHelper.m_13851_((JsonObject)json, (String)"mode", (String)"inscribe")) {
            case "inscribe" -> InscriberProcessType.INSCRIBE;
            case "press" -> InscriberProcessType.PRESS;
            default -> throw new IllegalStateException("Unknown mode for inscriber recipe: " + mode);
        };
    }

    public InscriberRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        InscriberProcessType mode = InscriberRecipeSerializer.getMode(json);
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        JsonObject ingredients = GsonHelper.m_13930_((JsonObject)json, (String)"ingredients");
        Ingredient middle = Ingredient.m_43917_((JsonElement)ingredients.get("middle"));
        Ingredient top = Ingredient.f_43901_;
        if (ingredients.has("top")) {
            top = Ingredient.m_43917_((JsonElement)ingredients.get("top"));
        }
        Ingredient bottom = Ingredient.f_43901_;
        if (ingredients.has("bottom")) {
            bottom = Ingredient.m_43917_((JsonElement)ingredients.get("bottom"));
        }
        return new InscriberRecipe(recipeId, middle, result, top, bottom, mode);
    }

    @Nullable
    public InscriberRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient middle = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack result = buffer.m_130267_();
        Ingredient top = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        Ingredient bottom = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        InscriberProcessType mode = (InscriberProcessType)buffer.m_130066_(InscriberProcessType.class);
        return new InscriberRecipe(recipeId, middle, result, top, bottom, mode);
    }

    public void toNetwork(FriendlyByteBuf buffer, InscriberRecipe recipe) {
        recipe.getMiddleInput().m_43923_(buffer);
        buffer.m_130055_(recipe.m_8043_());
        recipe.getTopOptional().m_43923_(buffer);
        recipe.getBottomOptional().m_43923_(buffer);
        buffer.m_130068_((Enum)recipe.getProcessType());
    }
}

