/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei;

import appeng.client.gui.style.Blitter;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.rei.EntropyManipulatorDisplay;
import appeng.integration.modules.rei.ReiPlugin;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import com.google.common.collect.Streams;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EntropyManipulatorCategory
implements DisplayCategory<EntropyManipulatorDisplay> {
    public static final CategoryIdentifier<EntropyManipulatorDisplay> ID = CategoryIdentifier.of((ResourceLocation)AppEng.makeId("entropy"));
    private final Blitter icon = Blitter.texture("item/entropy_manipulator.png", 16, 16).src(0, 0, 16, 16);
    private final Widget blockDestroyOverlay = Widgets.createTexturedWidget((ResourceLocation)ReiPlugin.TEXTURE, (int)0, (int)0, (float)0.0f, (float)52.0f, (int)16, (int)16);
    private final Widget iconHeat = Widgets.createTexturedWidget((ResourceLocation)ReiPlugin.TEXTURE, (int)0, (int)0, (float)0.0f, (float)68.0f, (int)6, (int)6);
    private final Widget iconCool = Widgets.createTexturedWidget((ResourceLocation)ReiPlugin.TEXTURE, (int)0, (int)0, (float)6.0f, (float)68.0f, (int)6, (int)6);
    private final int centerX;

    public EntropyManipulatorCategory() {
        this.centerX = 65;
    }

    private void setFluidOrBlockSlot(Slot slot, Block block, Fluid fluid) {
        if (fluid != null) {
            if (!fluid.m_7444_(fluid.m_76145_())) {
                if (fluid instanceof FlowingFluid) {
                    FlowingFluid flowingFluid = (FlowingFluid)fluid;
                    EntropyManipulatorCategory.addFluidStack(slot, flowingFluid.m_5613_());
                } else {
                    EntropyManipulatorCategory.addFluidStack(slot, fluid);
                    AELog.warn("Don't know how to get the source fluid for %s", fluid);
                }
                for (EntryStack entry : slot.getEntries()) {
                    ClientEntryStacks.setTooltipProcessor((EntryStack)entry, (entryStack, tooltip) -> {
                        List entries = tooltip.entries();
                        Stream lines = Streams.concat((Stream[])new Stream[]{Stream.of(Tooltip.entry((Component)ItemModText.FLOWING_FLUID_NAME.text(((Tooltip.Entry)entries.get(0)).getAsText()))), entries.stream().skip(1L)});
                        return Tooltip.from((Point)new Point(tooltip.getX(), tooltip.getY()), lines.toList());
                    });
                }
            } else {
                EntropyManipulatorCategory.addFluidStack(slot, fluid);
            }
        } else if (block != null) {
            slot.entry(EntryStacks.of((ItemLike)block));
        }
    }

    private static void addFluidStack(Slot slot, Fluid fluid) {
        slot.entry(EntryStacks.of((Fluid)fluid, (long)1000L));
    }

    public CategoryIdentifier<? extends EntropyManipulatorDisplay> getCategoryIdentifier() {
        return ID;
    }

    public Component getTitle() {
        return AEItems.ENTROPY_MANIPULATOR.m_5456_().m_41466_();
    }

    public Renderer getIcon() {
        return new AbstractRenderer(){

            public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                EntropyManipulatorCategory.this.icon.dest(bounds.x, bounds.y).blit(matrices, this.m_93252_());
            }
        };
    }

    public List<Widget> setupDisplay(EntropyManipulatorDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        EntropyRecipe recipe = display.getRecipe();
        Widget icon = switch (recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> this.iconHeat;
            case EntropyMode.COOL -> this.iconCool;
        };
        MutableComponent labelText = switch (recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.ENTROPY_MANIPULATOR_HEAT.text(1600);
            case EntropyMode.COOL -> ItemModText.ENTROPY_MANIPULATOR_COOL.text(1600);
        };
        MutableComponent interaction = switch (recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.RIGHT_CLICK.text();
            case EntropyMode.COOL -> ItemModText.SHIFT_RIGHT_CLICK.text();
        };
        Label modeLabel = Widgets.createLabel((Point)new Point(this.centerX + 4, 2), (Component)labelText).noShadow().color(0x7E7E7E);
        widgets.add((Widget)modeLabel);
        widgets.add((Widget)Widgets.withTranslate((Widget)icon, (double)(modeLabel.getBounds().getX() - 9), (double)3.0, (double)0.0));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(this.centerX - 12, 14)));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(this.centerX, 38), (Component)interaction).noShadow().color(0x7E7E7E));
        this.setupSlots(widgets, recipe);
        for (int i = 0; i < widgets.size(); ++i) {
            if (i <= 0) continue;
            widgets.set(i, (Widget)Widgets.withTranslate((Widget)widgets.get(i), (double)bounds.x, (double)(bounds.y + 3), (double)0.0));
        }
        return widgets;
    }

    private void setupSlots(ArrayList<Widget> widgets, EntropyRecipe recipe) {
        Slot input = Widgets.createSlot((Point)new Point(this.centerX - 36, 15)).backgroundEnabled(true).markInput();
        widgets.add((Widget)input);
        this.setFluidOrBlockSlot(input, recipe.getInputBlock(), recipe.getInputFluid());
        int x = this.centerX + 20;
        if (recipe.getOutputBlock() == Blocks.f_50016_ && (recipe.getOutputFluid() == null || recipe.getOutputFluid() == Fluids.f_76191_)) {
            Slot destroyed = Widgets.createSlot((Point)new Point(x, 15)).backgroundEnabled(true).unmarkInputOrOutput();
            widgets.add((Widget)destroyed);
            this.setFluidOrBlockSlot(destroyed, recipe.getInputBlock(), recipe.getInputFluid());
            widgets.add((Widget)Widgets.withTranslate((Widget)this.blockDestroyOverlay, (double)x, (double)15.0, (double)0.0));
            for (EntryStack entry : destroyed.getEntries()) {
                entry.tooltip(new Component[]{ItemModText.CONSUMED.text().m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})});
            }
            x += 18;
        } else if (recipe.getOutputBlock() != null || recipe.getOutputFluid() != null) {
            Slot output = Widgets.createSlot((Point)new Point(x, 15)).backgroundEnabled(true).markOutput();
            widgets.add((Widget)output);
            this.setFluidOrBlockSlot(output, recipe.getOutputBlock(), recipe.getOutputFluid());
            x += 18;
        }
        for (ItemStack drop : recipe.getDrops()) {
            Slot output = Widgets.createSlot((Point)new Point(x, 15)).backgroundEnabled(true).markOutput();
            widgets.add((Widget)output);
            output.entry(EntryStacks.of((ItemStack)drop));
            x += 18;
        }
    }

    public int getDisplayWidth(EntropyManipulatorDisplay display) {
        return 130;
    }

    public int getDisplayHeight() {
        return 55;
    }
}

