/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.block.AEBaseBlock;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.model.AutoRotatingBakedModel;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class InitAutoRotatingModel {
    private static final Set<BlockDefinition<?>> NO_AUTO_ROTATION = ImmutableSet.of(AEBlocks.CABLE_BUS, AEBlocks.CONTROLLER, AEBlocks.PAINT, AEBlocks.QUANTUM_LINK, AEBlocks.QUANTUM_RING, AEBlocks.CRAFTING_UNIT, (Object[])new BlockDefinition[]{AEBlocks.CRAFTING_ACCELERATOR, AEBlocks.CRAFTING_MONITOR, AEBlocks.CRAFTING_STORAGE_1K, AEBlocks.CRAFTING_STORAGE_4K, AEBlocks.CRAFTING_STORAGE_16K, AEBlocks.CRAFTING_STORAGE_64K, AEBlocks.CRAFTING_STORAGE_256K});
    private static final Map<String, Function<BakedModel, BakedModel>> CUSTOMIZERS = new HashMap<String, Function<BakedModel, BakedModel>>();

    private InitAutoRotatingModel() {
    }

    public static void init(IEventBus modEventBus) {
        InitAutoRotatingModel.register(AEBlocks.CRAFTING_MONITOR, InitAutoRotatingModel::customizeCraftingMonitorModel);
        for (BlockDefinition<?> block : AEBlocks.getBlocks()) {
            if (NO_AUTO_ROTATION.contains(block) || !(block.block() instanceof AEBaseBlock)) continue;
            InitAutoRotatingModel.register(block, AutoRotatingBakedModel::new);
        }
        modEventBus.addListener(InitAutoRotatingModel::onModelBake);
    }

    private static void register(BlockDefinition<?> block, Function<BakedModel, BakedModel> customizer) {
        String path = block.id().m_135815_();
        CUSTOMIZERS.put(path, customizer);
    }

    private static BakedModel customizeCraftingMonitorModel(BakedModel model) {
        if (model instanceof MonitorBakedModel) {
            return model;
        }
        return new AutoRotatingBakedModel(model);
    }

    private static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        HashSet keys = Sets.newHashSet(modelRegistry.keySet());
        BakedModel missingModel = (BakedModel)modelRegistry.get(ModelBakery.f_119230_);
        for (ResourceLocation location : keys) {
            BakedModel newModel;
            Function<BakedModel, BakedModel> customizer;
            BakedModel orgModel;
            if (!location.m_135827_().equals("ae2") || (orgModel = (BakedModel)modelRegistry.get(location)) == missingModel || (customizer = CUSTOMIZERS.get(location.m_135815_())) == null || (newModel = customizer.apply(orgModel)) == orgModel) continue;
            modelRegistry.put(location, newModel);
        }
    }
}

