/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.mixins.unlitquad.BakedQuadAccessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class UnlitQuadHooks {
    private static final int LIGHT_OFFSET = UnlitQuadHooks.getLightOffset();
    private static final int UNLIT_LIGHT_UV = LightTexture.m_109885_((int)15, (int)15);
    private static final ThreadLocal<Boolean> ENABLE_UNLIT_EXTENSIONS = new ThreadLocal();

    public static void beginDeserializingModel(ResourceLocation location) {
        String namespace = location.m_135827_();
        if (namespace.equals("ae2")) {
            ENABLE_UNLIT_EXTENSIONS.set(true);
        }
    }

    public static void endDeserializingModel() {
        ENABLE_UNLIT_EXTENSIONS.set(false);
    }

    public static boolean isUnlitExtensionEnabled() {
        Boolean b = ENABLE_UNLIT_EXTENSIONS.get();
        return b != null && b != false;
    }

    public static BlockElementFace enhanceModelElementFace(BlockElementFace modelElement, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (GsonHelper.m_13855_((JsonObject)jsonObject, (String)"unlit", (boolean)false)) {
            return new UnlitBlockPartFace(modelElement.f_111354_, modelElement.f_111355_, modelElement.f_111356_, modelElement.f_111357_);
        }
        return modelElement;
    }

    public static BakedQuad makeUnlit(BakedQuad quad) {
        int[] vertexData = (int[])quad.m_111303_().clone();
        int stride = DefaultVertexFormat.f_85811_.m_86017_();
        for (int i = 0; i < 4; ++i) {
            vertexData[stride * i + UnlitQuadHooks.LIGHT_OFFSET] = UNLIT_LIGHT_UV;
        }
        TextureAtlasSprite sprite = ((BakedQuadAccessor)quad).getSprite();
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), sprite, false);
    }

    private static int getLightOffset() {
        VertexFormat format = DefaultVertexFormat.f_85811_;
        int offset = 0;
        for (VertexFormatElement element : format.m_86023_()) {
            if (element == DefaultVertexFormat.f_85808_) {
                if (element.m_86041_() != VertexFormatElement.Type.SHORT) {
                    throw new UnsupportedOperationException("Expected light map format to be of type SHORT");
                }
                if (offset % 4 != 0) {
                    throw new UnsupportedOperationException("Expected light map offset to be 4-byte aligned");
                }
                return offset / 4;
            }
            offset += element.m_86050_();
        }
        throw new UnsupportedOperationException("Failed to find the lightmap index in the block vertex format");
    }

    public static class UnlitBlockPartFace
    extends BlockElementFace {
        public UnlitBlockPartFace(Direction cullFaceIn, int tintIndexIn, String textureIn, BlockFaceUV blockFaceUVIn) {
            super(cullFaceIn, tintIndexIn, textureIn, blockFaceUVIn);
        }
    }
}

