/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.recipes;

import appeng.core.AppEng;
import appeng.datagen.providers.recipes.AE2RecipeProvider;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EntropyRecipes
extends AE2RecipeProvider {
    public EntropyRecipes(DataGenerator generator) {
        super(generator);
    }

    @Override
    protected void buildAE2CraftingRecipes(Consumer<FinishedRecipe> consumer) {
        this.buildCoolRecipes(consumer);
        this.buildHeatRecipes(consumer);
    }

    private void buildCoolRecipes(Consumer<FinishedRecipe> consumer) {
        EntropyRecipes.cool("flowing_water_snowball").setInputFluid((Fluid)Fluids.f_76192_).setDrops(new ItemStack((ItemLike)Items.f_42452_)).save(consumer);
        EntropyRecipes.cool("grass_block_dirt").setInputBlock(Blocks.f_50440_).setOutputBlock(Blocks.f_50493_).save(consumer);
        EntropyRecipes.cool("lava_obsidian").setInputFluid((Fluid)Fluids.f_76195_).setOutputBlock(Blocks.f_50080_).save(consumer);
        EntropyRecipes.cool("stone_bricks_cracked_stone_bricks").setInputBlock(Blocks.f_50222_).setOutputBlock(Blocks.f_50224_).save(consumer);
        EntropyRecipes.cool("stone_cobblestone").setInputBlock(Blocks.f_50069_).setOutputBlock(Blocks.f_50652_).save(consumer);
        EntropyRecipes.cool("water_ice").setInputFluid((Fluid)Fluids.f_76193_).setOutputBlock(Blocks.f_50126_).save(consumer);
    }

    private void buildHeatRecipes(Consumer<FinishedRecipe> consumer) {
        EntropyRecipes.heat("cobblestone_stone").setInputBlock(Blocks.f_50652_).setOutputBlock(Blocks.f_50069_).save(consumer);
        EntropyRecipes.heat("ice_water").setInputBlock(Blocks.f_50126_).setOutputFluid((Fluid)Fluids.f_76193_).save(consumer);
        EntropyRecipes.heat("snow_water").setInputBlock(Blocks.f_50125_).setOutputFluid((Fluid)Fluids.f_76192_).save(consumer);
        EntropyRecipes.heat("water_air").setInputFluid((Fluid)Fluids.f_76193_).setOutputBlock(Blocks.f_50016_).save(consumer);
    }

    private static EntropyRecipeBuilder cool(String id) {
        return new EntropyRecipeBuilder().setId(AppEng.makeId("entropy/cool/" + id)).setMode(EntropyMode.COOL);
    }

    private static EntropyRecipeBuilder heat(String id) {
        return new EntropyRecipeBuilder().setId(AppEng.makeId("entropy/heat/" + id)).setMode(EntropyMode.HEAT);
    }
}

