/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.loot;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.loot.NeededPressType;
import appeng.loot.NeedsPressCondition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ChestDropProvider
implements IAE2DataProvider {
    private static final LootItemCondition.Builder NEEDS_CALCULATION_PROCESSOR_PRESS = () -> new NeedsPressCondition(NeededPressType.CALCULATION_PROCESSOR_PRESS);
    private static final LootItemCondition.Builder NEEDS_ENGINEERING_PROCESSOR_PRESS = () -> new NeedsPressCondition(NeededPressType.ENGINEERING_PROCESSOR_PRESS);
    private static final LootItemCondition.Builder NEEDS_LOGIC_PROCESSOR_PRESS = () -> new NeedsPressCondition(NeededPressType.LOGIC_PROCESSOR_PRESS);
    private static final LootItemCondition.Builder NEEDS_SILICON_PRESS = () -> new NeedsPressCondition(NeededPressType.SILICON_PRESS);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path outputFolder;

    public ChestDropProvider(Path outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void m_6865_(HashCache cache) throws IOException {
        LootTable.Builder meteoriteChestTable = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)).m_165135_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEBlocks.SKY_STONE_BLOCK).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)12.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)12.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.CERTUS_QUARTZ_CRYSTAL).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_165135_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_(AEItems.CALCULATION_PROCESSOR_PRESS).m_6509_(NEEDS_CALCULATION_PROCESSOR_PRESS)).m_79076_(LootItem.m_79579_(AEItems.ENGINEERING_PROCESSOR_PRESS).m_6509_(NEEDS_ENGINEERING_PROCESSOR_PRESS)).m_79076_(LootItem.m_79579_(AEItems.LOGIC_PROCESSOR_PRESS).m_6509_(NEEDS_LOGIC_PROCESSOR_PRESS)).m_79076_(LootItem.m_79579_(AEItems.SILICON_PRESS).m_6509_(NEEDS_SILICON_PRESS))).m_79161_(LootPool.m_79043_().m_6509_(InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{NEEDS_CALCULATION_PROCESSOR_PRESS, NEEDS_ENGINEERING_PROCESSOR_PRESS, NEEDS_LOGIC_PROCESSOR_PRESS, NEEDS_SILICON_PRESS}))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_165135_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.CALCULATION_PROCESSOR_PRESS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.ENGINEERING_PROCESSOR_PRESS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.LOGIC_PROCESSOR_PRESS)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.SILICON_PRESS)));
        DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)this.toJson(meteoriteChestTable), (Path)this.getPath(this.outputFolder, AppEng.makeId("meteorite")));
    }

    private Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/chests/" + id.m_135815_() + ".json");
    }

    public JsonElement toJson(LootTable.Builder builder) {
        return LootTables.m_79200_((LootTable)this.finishBuilding(builder));
    }

    public LootTable finishBuilding(LootTable.Builder builder) {
        return builder.m_79165_(LootContextParamSets.f_81411_).m_79167_();
    }

    public String m_6055_() {
        return "Applied Energistics 2 Chest Drops";
    }
}

