/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.PatternProviderLockReason;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigButtonPacket;
import appeng.menu.implementations.PatternProviderMenu;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class PatternProviderScreen
extends AEBaseScreen<PatternProviderMenu> {
    private final SettingToggleButton<YesNo> blockingModeButton = new ServerSettingToggleButton<YesNo>(Settings.BLOCKING_MODE, YesNo.NO);
    private final SettingToggleButton<LockCraftingMode> lockCraftingModeButton;
    private final ToggleButton showInInterfaceTerminalButton;
    private final PatternProviderLockReason lockReason;

    public PatternProviderScreen(PatternProviderMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.addToLeftToolbar(this.blockingModeButton);
        this.lockCraftingModeButton = new ServerSettingToggleButton<LockCraftingMode>(Settings.LOCK_CRAFTING_MODE, LockCraftingMode.NONE);
        this.addToLeftToolbar(this.lockCraftingModeButton);
        this.widgets.addOpenPriorityButton();
        this.showInInterfaceTerminalButton = new ToggleButton(Icon.PATTERN_ACCESS_SHOW, Icon.PATTERN_ACCESS_HIDE, (Component)GuiText.PatternAccessTerminal.text(), (Component)GuiText.PatternAccessTerminalHint.text(), btn -> this.selectNextInterfaceMode());
        this.addToLeftToolbar(this.showInInterfaceTerminalButton);
        this.lockReason = new PatternProviderLockReason(this);
        this.widgets.add("lockReason", this.lockReason);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.lockReason.setVisible(((PatternProviderMenu)this.f_97732_).getLockCraftingMode() != LockCraftingMode.NONE);
        this.blockingModeButton.set(((PatternProviderMenu)this.f_97732_).getBlockingMode());
        this.lockCraftingModeButton.set(((PatternProviderMenu)this.f_97732_).getLockCraftingMode());
        this.showInInterfaceTerminalButton.setState(((PatternProviderMenu)this.f_97732_).getShowInAccessTerminal() == YesNo.YES);
    }

    private void selectNextInterfaceMode() {
        boolean backwards = this.isHandlingRightClick();
        NetworkHandler.instance().sendToServer(new ConfigButtonPacket(Settings.PATTERN_ACCESS_TERMINAL, backwards));
    }
}

