/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.blockentity.AEBaseBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SkyStoneTankBlockEntity
extends AEBaseBlockEntity {
    public static final int BUCKET_CAPACITY = 16;
    protected FluidTank tank = new FluidTank(16000){

        protected void onContentsChanged() {
            SkyStoneTankBlockEntity.this.markForUpdate();
            SkyStoneTankBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public SkyStoneTankBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        if (!this.tank.isEmpty()) {
            this.tank.writeToNBT(data);
        }
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.tank.readFromNBT(data);
    }

    public boolean onPlayerUse(Player player) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (IFluidHandler)this.tank);
    }

    public IFluidHandler getStorage(Direction direction) {
        return this.tank;
    }

    public IFluidTank getStorage() {
        return this.tank;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean ret = super.readFromStream(data);
        this.tank.readFromNBT(data.m_130260_());
        return ret;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        CompoundTag tag = new CompoundTag();
        this.tank.writeToNBT(tag);
        data.m_130079_(tag);
    }
}

