/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.impl.ObjectDataCenter;
import mcp.mobius.waila.impl.config.ConfigEntry;
import mcp.mobius.waila.impl.config.PluginConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ServerPingPacket {
    public Map<ResourceLocation, Boolean> forcedKeys = Maps.newHashMap();

    public ServerPingPacket(@Nullable Map<ResourceLocation, Boolean> forcedKeys) {
        this.forcedKeys = forcedKeys;
    }

    public ServerPingPacket(PluginConfig config) {
        Set<ConfigEntry> entries = config.getSyncableConfigs();
        entries.forEach(e -> this.forcedKeys.put(e.getId(), e.getValue()));
    }

    public static ServerPingPacket read(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap temp = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = new ResourceLocation(buffer.m_130136_(128));
            boolean value = buffer.readBoolean();
            temp.put(id, value);
        }
        return new ServerPingPacket(temp);
    }

    public static void write(ServerPingPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.forcedKeys.size());
        message.forcedKeys.forEach((k, v) -> {
            buffer.m_130070_(k.toString());
            buffer.writeBoolean(v.booleanValue());
        });
    }

    public static class Handler {
        public static void onMessage(ServerPingPacket message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ObjectDataCenter.serverConnected = true;
                message.forcedKeys.forEach(PluginConfig.INSTANCE::set);
                Waila.LOGGER.info("Received config from the server: {}", (Object)new Gson().toJson(message.forcedKeys));
            });
            context.get().setPacketHandled(true);
        }
    }
}

