/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.core.TagBuilderKJS;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerSettings;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import org.jetbrains.annotations.Nullable;

public class TagEventJS<T>
extends EventJS {
    private final String type;
    private final Map<ResourceLocation, Tag.Builder> map;
    private final Registry<T> registry;
    private Map<ResourceLocation, TagWrapper> tags;
    private int totalAdded;
    private int totalRemoved;
    private List<Predicate<ResourceLocation>> globalPriorityList;

    private static String getIdOfEntry(Tag.Entry entry) {
        JsonElement asJson = ((JsonArray)Util.m_137469_((Object)new JsonArray(), arg_0 -> ((Tag.Entry)entry).m_6383_(arg_0))).get(0);
        if (asJson instanceof JsonObject) {
            JsonObject obj = (JsonObject)asJson;
            return obj.get("id").getAsString();
        }
        return asJson.getAsString();
    }

    @Nullable
    private static List<Predicate<ResourceLocation>> parsePriorityList(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Predicate<ResourceLocation>> list = new ArrayList<Predicate<ResourceLocation>>();
        for (Object o1 : ListJS.orSelf(o)) {
            String m;
            String s = String.valueOf(o1);
            if (s.startsWith("@")) {
                m = s.substring(1);
                list.add(id -> id.m_135827_().equals(m));
                continue;
            }
            if (s.startsWith("!@")) {
                m = s.substring(2);
                list.add(id -> !id.m_135827_().equals(m));
                continue;
            }
            list.add(id -> id.equals((Object)UtilsJS.getMCID(s)));
        }
        return list.isEmpty() ? null : list;
    }

    public TagEventJS(String t, Map<ResourceLocation, Tag.Builder> m, Registry<T> r) {
        this.type = t;
        this.map = m;
        this.registry = r;
        this.totalAdded = 0;
        this.totalRemoved = 0;
        this.globalPriorityList = null;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void post(String event) {
        Path dumpFile = KubeJSPaths.EXPORTED.resolve("tags/" + this.type + ".txt");
        if (!Files.exists(dumpFile, new LinkOption[0])) {
            try {
                if (!Files.exists(dumpFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dumpFile.getParent(), new FileAttribute[0]);
                }
                ArrayList<CallSite> lines = new ArrayList<CallSite>();
                this.map.forEach((tagId, tagBuilder) -> {
                    lines.add((CallSite)((Object)""));
                    lines.add((CallSite)((Object)("#" + tagId)));
                    tagBuilder.m_13330_().forEach(builderEntry -> lines.add((CallSite)((Object)("- " + builderEntry.f_13338_()))));
                });
                lines.add(0, (CallSite)((Object)("To refresh this file, delete it and run /reload command again! Last updated: " + DateFormat.getDateTimeInstance().format(new Date()))));
                Files.write(dumpFile, lines, new OpenOption[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.tags = new HashMap<ResourceLocation, TagWrapper>();
        for (Map.Entry<ResourceLocation, Tag.Builder> entry : this.map.entrySet()) {
            TagWrapper tagWrapper = new TagWrapper(entry.getKey(), entry.getValue());
            this.tags.put(entry.getKey(), tagWrapper);
            ConsoleJS.SERVER.debug("%s/#%s; %d".formatted(this.type, entry.getKey(), tagWrapper.proxyList.size()));
        }
        RegistryObjectBuilderTypes<?> types = RegistryObjectBuilderTypes.MAP.get(this.registry.m_123023_());
        if (types != null) {
            for (BuilderBase builderBase : types.objects.values()) {
                for (ResourceLocation s : builderBase.defaultTags) {
                    this.add(s, builderBase.id.toString());
                }
            }
        }
        ConsoleJS.SERVER.setLineNumber(true);
        this.post(ScriptType.SERVER, event);
        ConsoleJS.SERVER.setLineNumber(false);
        boolean bl = false;
        for (TagWrapper wrapper : this.tags.values()) {
            void var4_9;
            if (wrapper.priorityList == null) {
                wrapper.priorityList = this.globalPriorityList;
            }
            if (wrapper.priorityList == null || !wrapper.sort()) continue;
            ++var4_9;
        }
        if (ServerSettings.dataExport != null && this.registry != null) {
            void var5_16;
            JsonObject tj1;
            JsonObject jsonObject = ServerSettings.dataExport.getAsJsonObject("tags");
            if (jsonObject == null) {
                JsonObject jsonObject2 = new JsonObject();
                ServerSettings.dataExport.add("tags", (JsonElement)jsonObject2);
            }
            if ((tj1 = var5_16.getAsJsonObject(this.type)) == null) {
                tj1 = new JsonObject();
                var5_16.add(this.type, (JsonElement)tj1);
            }
            for (Map.Entry<ResourceLocation, Tag.Builder> entry : this.map.entrySet()) {
                JsonArray a = new JsonArray();
                entry.getValue().m_13330_().forEach(e -> a.add(e.f_13338_().toString()));
                tj1.add(entry.getKey().toString(), (JsonElement)a);
            }
        }
        if (this.totalAdded > 0 || this.totalRemoved > 0 || ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.info("[" + this.type + "] Found " + this.tags.size() + " tags, added " + this.totalAdded + " objects, removed " + this.totalRemoved + " objects");
        }
    }

    public TagWrapper get(ResourceLocation id) {
        TagWrapper t = this.tags.get(id);
        if (t == null) {
            t = new TagWrapper(id, Tag.Builder.m_13304_());
            this.tags.put(id, t);
            this.map.put(id, t.builder);
        }
        return t;
    }

    public TagWrapper add(ResourceLocation tag, String ... ids) {
        return this.get(tag).add(ids);
    }

    public TagWrapper remove(ResourceLocation tag, String ... ids) {
        return this.get(tag).remove(ids);
    }

    public TagWrapper removeAll(ResourceLocation tag) {
        return this.get(tag).removeAll();
    }

    public void removeAllTagsFrom(String ... ids) {
        for (String id : ids) {
            for (TagWrapper tagWrapper : this.tags.values()) {
                tagWrapper.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.f_13338_()).equals(id));
            }
        }
    }

    public void setGlobalPriorityList(@Nullable Object o) {
        this.globalPriorityList = TagEventJS.parsePriorityList(o);
    }

    private Either<TagWrapper, List<Holder.Reference<T>>> gatherTargets(String target) {
        if (target.isEmpty()) {
            return Either.right(List.of());
        }
        String suffix = target.substring(1);
        return switch (target.charAt(0)) {
            case '#' -> Either.left((Object)this.get(new ResourceLocation(suffix)));
            case '@' -> Either.right(this.ofKeySet(id -> id.m_135782_().m_135827_().equals(suffix)));
            case '/' -> Either.right(this.ofKeySet(id -> UtilsJS.parseRegex(target).matcher(id.m_135782_().toString()).find()));
            default -> {
                ResourceKey id = ResourceKey.m_135785_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)new ResourceLocation(target));
                yield (Either)UtilsJS.cast(Either.right(List.of(this.registry.m_206081_(id))));
            }
        };
    }

    private List<Holder.Reference<T>> ofKeySet(Predicate<ResourceKey<T>> predicate) {
        return this.registry.m_203611_().filter(ref -> ref.m_203425_(predicate)).toList();
    }

    public class TagWrapper {
        private final ResourceLocation id;
        private final Tag.Builder builder;
        private final List<Tag.BuilderEntry> proxyList;
        private List<Predicate<ResourceLocation>> priorityList;

        private TagWrapper(ResourceLocation i, Tag.Builder t) {
            this.id = i;
            this.builder = t;
            this.proxyList = ((TagBuilderKJS)this.builder).getProxyListKJS();
            this.priorityList = null;
        }

        public String toString() {
            return "<%s / %s>".formatted(TagEventJS.this.type, this.id);
        }

        public TagWrapper add(String ... ids) {
            for (String stringId : ids) {
                TagEventJS.this.gatherTargets(stringId).ifLeft(wrapper -> {
                    this.builder.m_13335_(wrapper.id, "kubejs");
                    TagEventJS.this.totalAdded += wrapper.proxyList.size();
                    if (ConsoleJS.SERVER.shouldPrintDebug()) {
                        ConsoleJS.SERVER.debug("+ %s // #%s".formatted(this, wrapper.id));
                    }
                }).ifRight(matches -> {
                    if (matches.isEmpty()) {
                        if (ServerSettings.instance.logSkippedRecipes) {
                            ConsoleJS.SERVER.warn("+ %s // %s [No matches found!]".formatted(this, stringId));
                        }
                        return;
                    }
                    TagEventJS.this.totalAdded += matches.size();
                    for (Holder.Reference holder : matches) {
                        ResourceLocation id = holder.m_205785_().m_135782_();
                        this.builder.m_13327_(id, "kubejs");
                        if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                        if (id.toString().equals(stringId)) {
                            ConsoleJS.SERVER.debug("+ %s // %s".formatted(this, id));
                            continue;
                        }
                        ConsoleJS.SERVER.debug("+ %s // %s (via %s)".formatted(this, id, stringId));
                    }
                });
            }
            return this;
        }

        public TagWrapper remove(String ... ids) {
            for (String stringId : ids) {
                TagEventJS.this.gatherTargets(stringId).ifLeft(wrapper -> {
                    String entryId = wrapper.id.toString();
                    int originalSize = this.proxyList.size();
                    this.proxyList.removeIf(proxy -> {
                        String proxyId = TagEventJS.getIdOfEntry(proxy.f_13338_());
                        if (proxyId.startsWith("#")) {
                            return proxyId.substring(1).equals(entryId);
                        }
                        return false;
                    });
                    int removedCount = originalSize - this.proxyList.size();
                    if (removedCount == 0) {
                        if (ServerSettings.instance.logSkippedRecipes) {
                            ConsoleJS.SERVER.warn("- %s // #%s [No matches found!]".formatted(this, entryId));
                        }
                    } else {
                        TagEventJS.this.totalRemoved += removedCount;
                        if (ConsoleJS.SERVER.shouldPrintDebug()) {
                            ConsoleJS.SERVER.debug("- " + this + " // " + entryId);
                        }
                    }
                }).ifRight(matches -> {
                    int originalSize = this.proxyList.size();
                    block0: for (Holder.Reference holder : matches) {
                        ResourceLocation id = holder.m_205785_().m_135782_();
                        ListIterator<Tag.BuilderEntry> iterator = this.proxyList.listIterator();
                        while (iterator.hasNext()) {
                            Tag.BuilderEntry proxy = iterator.next();
                            if (!TagEventJS.getIdOfEntry(proxy.f_13338_()).equals(id.toString())) continue;
                            iterator.remove();
                            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue block0;
                            if (id.toString().equals(stringId)) {
                                ConsoleJS.SERVER.debug("- %s // %s".formatted(this, id));
                                continue block0;
                            }
                            ConsoleJS.SERVER.debug("- %s // %s (via %s)".formatted(this, id, stringId));
                            continue block0;
                        }
                    }
                    int removedCount = originalSize - this.proxyList.size();
                    if (removedCount == 0) {
                        if (ServerSettings.instance.logSkippedRecipes) {
                            ConsoleJS.SERVER.warn("- %s // %s [No matches found!]".formatted(this, stringId));
                        }
                    } else {
                        TagEventJS.this.totalRemoved += removedCount;
                    }
                });
            }
            return this;
        }

        public TagWrapper removeAll() {
            if (ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.debug("- " + this + " // (all)");
            }
            if (!this.proxyList.isEmpty()) {
                TagEventJS.this.totalRemoved += this.proxyList.size();
                this.proxyList.clear();
            } else if (ServerSettings.instance.logSkippedRecipes) {
                ConsoleJS.SERVER.warn("Tag " + this + " didn't contain any elements, skipped");
            }
            return this;
        }

        public Collection<ResourceLocation> getObjectIds() {
            LinkedHashSet<ResourceLocation> set = new LinkedHashSet<ResourceLocation>();
            for (Tag.BuilderEntry proxy : this.proxyList) {
                this.gatherIdsFor(set, proxy.f_13338_());
            }
            return set;
        }

        private void gatherIdsFor(Collection<ResourceLocation> collection, Tag.Entry entry) {
            String id = TagEventJS.getIdOfEntry(entry);
            if (id.startsWith("#")) {
                TagWrapper w = TagEventJS.this.tags.get(new ResourceLocation(id.substring(1)));
                if (w != null && w != this) {
                    for (Tag.BuilderEntry proxy : w.proxyList) {
                        this.gatherIdsFor(collection, proxy.f_13338_());
                    }
                }
            } else {
                ResourceLocation entryId = new ResourceLocation(id);
                if (TagEventJS.this.registry.m_7804_(entryId)) {
                    collection.add(entryId);
                }
            }
        }

        public void setPriorityList(@Nullable Object o) {
            this.priorityList = TagEventJS.parsePriorityList(o);
        }

        public boolean sort() {
            ArrayList listOfLists = new ArrayList();
            for (int i = 0; i < this.priorityList.size() + 1; ++i) {
                listOfLists.add(new ArrayList());
            }
            for (Tag.BuilderEntry proxy : this.proxyList) {
                boolean bl = false;
                HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
                this.gatherIdsFor(set, proxy.f_13338_());
                block2: for (ResourceLocation id : set) {
                    for (int i = 0; i < this.priorityList.size(); ++i) {
                        if (!this.priorityList.get(i).test(id)) continue;
                        ((List)listOfLists.get(i)).add(proxy);
                        bl = true;
                        continue block2;
                    }
                }
                if (bl) continue;
                ((List)listOfLists.get(this.priorityList.size())).add(proxy);
            }
            ArrayList<Tag.BuilderEntry> proxyList0 = new ArrayList<Tag.BuilderEntry>(this.proxyList);
            this.proxyList.clear();
            for (List list : listOfLists) {
                this.proxyList.addAll(list);
            }
            if (!proxyList0.equals(this.proxyList)) {
                if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("* Re-arranged " + this);
                }
                return true;
            }
            return false;
        }
    }
}

