/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.net.PaintMessage;
import dev.latvian.mods.kubejs.net.SendDataFromServerMessage;
import dev.latvian.mods.kubejs.player.AdvancementJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.player.PlayerStatsJS;
import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import java.util.Date;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.Nullable;

public class ServerPlayerJS
extends PlayerJS<ServerPlayer> {
    public final ServerJS server;
    private final boolean hasClientMod;

    public ServerPlayerJS(ServerPlayerDataJS data, ServerPlayer player) {
        super(data, player);
        this.server = data.getServer();
        this.hasClientMod = data.hasClientMod();
    }

    @Override
    public PlayerStatsJS getStats() {
        return new PlayerStatsJS(this, (StatsCounter)((ServerPlayer)this.minecraftPlayer).m_8951_());
    }

    @Override
    public void paint(CompoundTag renderer) {
        new PaintMessage(renderer).sendTo((ServerPlayer)this.minecraftPlayer);
    }

    @Override
    public boolean isMiningBlock() {
        return ((ServerPlayer)this.minecraftPlayer).f_8941_.f_9249_;
    }

    public void setCreativeMode(boolean mode) {
        ((ServerPlayer)this.minecraftPlayer).m_143403_(mode ? GameType.CREATIVE : GameType.SURVIVAL);
    }

    public void setGameMode(String mode) {
        switch (mode) {
            case "survival": {
                ((ServerPlayer)this.minecraftPlayer).m_143403_(GameType.SURVIVAL);
                break;
            }
            case "creative": {
                ((ServerPlayer)this.minecraftPlayer).m_143403_(GameType.CREATIVE);
                break;
            }
            case "adventure": {
                ((ServerPlayer)this.minecraftPlayer).m_143403_(GameType.ADVENTURE);
                break;
            }
            case "spectator": {
                ((ServerPlayer)this.minecraftPlayer).m_143403_(GameType.SPECTATOR);
            }
        }
    }

    public boolean isOp() {
        return this.server.getMinecraftServer().m_6846_().m_11303_(((ServerPlayer)this.minecraftPlayer).m_36316_());
    }

    public void kick(Component reason) {
        ((ServerPlayer)this.minecraftPlayer).f_8906_.m_9942_(reason);
    }

    public void kick() {
        this.kick((Component)new TranslatableComponent("multiplayer.disconnect.kicked"));
    }

    public void ban(String banner, String reason, long expiresInMillis) {
        Date date = new Date();
        UserBanListEntry userlistbansentry = new UserBanListEntry(((ServerPlayer)this.minecraftPlayer).m_36316_(), date, banner, new Date(date.getTime() + (expiresInMillis <= 0L ? 315569260000L : expiresInMillis)), reason);
        this.server.getMinecraftServer().m_6846_().m_11295_().m_11381_((StoredUserEntry)userlistbansentry);
        this.kick((Component)new TranslatableComponent("multiplayer.disconnect.banned"));
    }

    public boolean getHasClientMod() {
        return this.hasClientMod;
    }

    public boolean isAdvancementDone(ResourceLocation id) {
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        return a != null && ((ServerPlayer)this.minecraftPlayer).m_8960_().m_135996_(a.advancement).m_8193_();
    }

    public void unlockAdvancement(ResourceLocation id) {
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        if (a != null) {
            AdvancementProgress advancementprogress = ((ServerPlayer)this.minecraftPlayer).m_8960_().m_135996_(a.advancement);
            for (String s : advancementprogress.m_8219_()) {
                ((ServerPlayer)this.minecraftPlayer).m_8960_().m_135988_(a.advancement, s);
            }
        }
    }

    public void revokeAdvancement(ResourceLocation id) {
        AdvancementProgress advancementprogress;
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        if (a != null && (advancementprogress = ((ServerPlayer)this.minecraftPlayer).m_8960_().m_135996_(a.advancement)).m_8206_()) {
            for (String s : advancementprogress.m_8220_()) {
                ((ServerPlayer)this.minecraftPlayer).m_8960_().m_135998_(a.advancement, s);
            }
        }
    }

    @Override
    public void setSelectedSlot(int index) {
        int p = this.getSelectedSlot();
        super.setSelectedSlot(index);
        int n = this.getSelectedSlot();
        if (p != n && ((ServerPlayer)this.minecraftPlayer).f_8906_ != null) {
            ((ServerPlayer)this.minecraftPlayer).f_8906_.m_141995_((Packet)new ClientboundSetCarriedItemPacket(n));
        }
    }

    @Override
    public void setMouseItem(ItemStackJS item) {
        super.setMouseItem(item);
        if (((ServerPlayer)this.minecraftPlayer).f_8906_ != null) {
            ((ServerPlayer)this.minecraftPlayer).f_36095_.m_38946_();
        }
    }

    @Override
    public void sendData(String channel, @Nullable CompoundTag data) {
        if (!channel.isEmpty()) {
            new SendDataFromServerMessage(channel, data).sendTo((ServerPlayer)this.minecraftPlayer);
        }
    }

    @Nullable
    public BlockContainerJS getSpawnLocation() {
        BlockPos pos = ((ServerPlayer)this.minecraftPlayer).m_8961_();
        return pos == null ? null : new BlockContainerJS(((ServerPlayer)this.minecraftPlayer).f_19853_, pos);
    }

    public void setSpawnLocation(BlockContainerJS c) {
        ((ServerPlayer)this.minecraftPlayer).m_9158_(c.minecraftLevel.m_46472_(), c.getPos(), 0.0f, true, false);
    }
}

