/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.mixin.common;

import dev.architectury.registry.fuel.FuelRegistry;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.core.ItemKJS;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.RemapForJS;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class}, priority=1001)
public abstract class ItemMixin
implements ItemKJS {
    @Shadow
    @Final
    public static int f_150886_;
    @Unique
    private ItemBuilder itemBuilderKJS;
    @Unique
    private final CompoundTag typeDataKJS = new CompoundTag();

    @Override
    @Nullable
    public ItemBuilder getItemBuilderKJS() {
        return this.itemBuilderKJS;
    }

    @Override
    public void setItemBuilderKJS(ItemBuilder b) {
        this.itemBuilderKJS = b;
    }

    @Override
    @RemapForJS(value="getTypeData")
    public CompoundTag getTypeDataKJS() {
        return this.typeDataKJS;
    }

    @Override
    @Accessor(value="maxStackSize")
    @Mutable
    public abstract void setMaxStackSizeKJS(int var1);

    @Override
    @Accessor(value="maxDamage")
    @Mutable
    public abstract void setMaxDamageKJS(int var1);

    @Override
    @Accessor(value="craftingRemainingItem")
    @Mutable
    public abstract void setCraftingRemainderKJS(Item var1);

    @Override
    @Accessor(value="isFireResistant")
    @Mutable
    public abstract void setFireResistantKJS(boolean var1);

    @Override
    @Accessor(value="rarity")
    @Mutable
    public abstract void setRarityKJS(Rarity var1);

    @Override
    @RemapForJS(value="setBurnTime")
    public void setBurnTimeKJS(int i) {
        FuelRegistry.register((int)i, (ItemLike[])new ItemLike[]{(Item)this});
    }

    @RemapForJS(value="getId")
    public String getIdKJS() {
        return KubeJSRegistries.items().getId((Object)((Item)this)).toString();
    }

    @Override
    @Accessor(value="foodProperties")
    @Mutable
    public abstract void setFoodPropertiesKJS(FoodProperties var1);

    @Inject(method={"isFoil"}, at={@At(value="HEAD")}, cancellable=true)
    private void isFoilKJS(ItemStack itemStack, CallbackInfoReturnable<Boolean> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.glow) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"appendHoverText"}, at={@At(value="RETURN")})
    private void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn, CallbackInfo ci) {
        if (this.itemBuilderKJS != null && !this.itemBuilderKJS.tooltip.isEmpty()) {
            tooltip.addAll(this.itemBuilderKJS.tooltip);
        }
    }

    @Inject(method={"isBarVisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void isBarVisible(ItemStack stack, CallbackInfoReturnable<Boolean> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.barWidth != null && this.itemBuilderKJS.barWidth.applyAsInt(ItemStackJS.of(stack)) <= f_150886_) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getBarWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBarWidth(ItemStack stack, CallbackInfoReturnable<Integer> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.barWidth != null) {
            ci.setReturnValue((Object)this.itemBuilderKJS.barWidth.applyAsInt(ItemStackJS.of(stack)));
        }
    }

    @Inject(method={"getBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBarColor(ItemStack stack, CallbackInfoReturnable<Integer> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.barColor != null) {
            ci.setReturnValue((Object)this.itemBuilderKJS.barColor.apply(ItemStackJS.of(stack)).getRgbJS());
        }
    }

    @Inject(method={"getUseDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void getUseDuration(ItemStack itemStack, CallbackInfoReturnable<Integer> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.useDuration != null) {
            ci.setReturnValue((Object)this.itemBuilderKJS.useDuration.applyAsInt(ItemStackJS.of(itemStack)));
        }
    }

    @Inject(method={"getUseAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void getUseAnimation(ItemStack itemStack, CallbackInfoReturnable<UseAnim> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.anim != null) {
            ci.setReturnValue((Object)this.itemBuilderKJS.anim);
        }
    }

    @Inject(method={"getName"}, at={@At(value="HEAD")}, cancellable=true)
    private void getName(ItemStack itemStack, CallbackInfoReturnable<Component> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.nameGetter != null) {
            ci.setReturnValue((Object)this.itemBuilderKJS.nameGetter.apply(ItemStackJS.of(itemStack)));
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void use(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.use != null) {
            ItemStack itemStack = player.m_21120_(interactionHand);
            LevelJS levelJS = UtilsJS.getLevel(level);
            if (this.itemBuilderKJS.use.use(levelJS, levelJS.getPlayer((Entity)player), interactionHand)) {
                ci.setReturnValue((Object)ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand));
            } else {
                ci.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)itemStack));
            }
        }
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity, CallbackInfoReturnable<ItemStack> ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.finishUsing != null) {
            LevelJS levelJS = UtilsJS.getLevel(level);
            ci.setReturnValue((Object)this.itemBuilderKJS.finishUsing.finishUsingItem(ItemStackJS.of(itemStack), levelJS, levelJS.getLivingEntity((Entity)livingEntity)).getItemStack());
        }
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")})
    private void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i, CallbackInfo ci) {
        if (this.itemBuilderKJS != null && this.itemBuilderKJS.releaseUsing != null) {
            LevelJS levelJS = UtilsJS.getLevel(level);
            this.itemBuilderKJS.releaseUsing.releaseUsing(ItemStackJS.of(itemStack), levelJS, levelJS.getLivingEntity((Entity)livingEntity), i);
        }
    }
}

