/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs;

import dev.architectury.registry.registries.DeferredRegister;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public final class RegistryObjectBuilderTypes<T> {
    public static final Map<ResourceKey<?>, RegistryObjectBuilderTypes<?>> MAP = new LinkedHashMap();
    public static final List<BuilderBase<?>> ALL_BUILDERS = new ArrayList();
    public static final RegistryObjectBuilderTypes<SoundEvent> SOUND_EVENT = RegistryObjectBuilderTypes.add(Registry.f_122898_, SoundEvent.class);
    public static final RegistryObjectBuilderTypes<Fluid> FLUID = RegistryObjectBuilderTypes.add(Registry.f_122899_, Fluid.class);
    public static final RegistryObjectBuilderTypes<Block> BLOCK = RegistryObjectBuilderTypes.add(Registry.f_122901_, Block.class);
    public static final RegistryObjectBuilderTypes<Item> ITEM = RegistryObjectBuilderTypes.add(Registry.f_122904_, Item.class);
    public static final RegistryObjectBuilderTypes<Enchantment> ENCHANTMENT = RegistryObjectBuilderTypes.add(Registry.f_122902_, Enchantment.class);
    public static final RegistryObjectBuilderTypes<MobEffect> MOB_EFFECT = RegistryObjectBuilderTypes.add(Registry.f_122900_, MobEffect.class);
    public static final RegistryObjectBuilderTypes<EntityType<?>> ENTITY_TYPE = RegistryObjectBuilderTypes.add(Registry.f_122903_, EntityType.class);
    public static final RegistryObjectBuilderTypes<BlockEntityType<?>> BLOCK_ENTITY_TYPE = RegistryObjectBuilderTypes.add(Registry.f_122907_, BlockEntityType.class);
    public static final RegistryObjectBuilderTypes<Potion> POTION = RegistryObjectBuilderTypes.add(Registry.f_122905_, Potion.class);
    public static final RegistryObjectBuilderTypes<ParticleType<?>> PARTICLE_TYPE = RegistryObjectBuilderTypes.add(Registry.f_122906_, ParticleType.class);
    public static final RegistryObjectBuilderTypes<Motive> MOTIVE = RegistryObjectBuilderTypes.add(Registry.f_122908_, Motive.class);
    public static final RegistryObjectBuilderTypes<ResourceLocation> CUSTOM_STAT = RegistryObjectBuilderTypes.add(Registry.f_122909_, ResourceLocation.class);
    public static final RegistryObjectBuilderTypes<PoiType> POINT_OF_INTEREST_TYPE = RegistryObjectBuilderTypes.add(Registry.f_122810_, PoiType.class);
    public static final RegistryObjectBuilderTypes<VillagerType> VILLAGER_TYPE = RegistryObjectBuilderTypes.add(Registry.f_122808_, VillagerType.class);
    public static final RegistryObjectBuilderTypes<VillagerProfession> VILLAGER_PROFESSION = RegistryObjectBuilderTypes.add(Registry.f_122809_, VillagerProfession.class);
    public final ResourceKey<Registry<T>> registryKey;
    public final Class<T> objectBaseClass;
    public final DeferredRegister<T> deferredRegister;
    public final Map<String, BuilderType<T>> types;
    public final Map<ResourceLocation, BuilderBase<? extends T>> objects;
    private BuilderType<T> defaultType;
    public BuilderBase<? extends T> current;
    public boolean bypassServerOnly;

    public static <T> RegistryObjectBuilderTypes<T> add(ResourceKey<Registry<T>> key, Class<?> baseClass) {
        RegistryObjectBuilderTypes<T> types = new RegistryObjectBuilderTypes<T>(key, (Class)UtilsJS.cast(baseClass));
        if (MAP.put(key, types) != null) {
            throw new IllegalStateException("Registry with id '" + key + "' already exists!");
        }
        return types;
    }

    private RegistryObjectBuilderTypes(ResourceKey<Registry<T>> key, Class<T> baseClass) {
        this.registryKey = key;
        this.objectBaseClass = baseClass;
        this.deferredRegister = DeferredRegister.create((String)"kubejs", this.registryKey);
        this.types = new LinkedHashMap<String, BuilderType<T>>();
        this.objects = new LinkedHashMap<ResourceLocation, BuilderBase<? extends T>>();
        this.current = null;
        this.bypassServerOnly = false;
    }

    public RegistryObjectBuilderTypes<T> bypassServerOnly() {
        this.bypassServerOnly = true;
        return this;
    }

    public void addType(String type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory<T> factory, boolean isDefault) {
        BuilderType<T> b = new BuilderType<T>(type, builderType, factory);
        this.types.put(type, b);
        if (isDefault) {
            if (this.defaultType != null) {
                ConsoleJS.STARTUP.warn("Previous default type '" + this.defaultType.type + "' for registry '" + this.registryKey.m_135782_() + "' replaced with '" + type + "'!");
            }
            this.defaultType = b;
        }
    }

    public void addType(String type, Class<? extends BuilderBase<? extends T>> builderType, BuilderFactory<T> factory) {
        this.addType(type, builderType, factory, type.equals("basic"));
    }

    public void addBuilder(BuilderBase<? extends T> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Can't add null builder in registry '" + this.registryKey.m_135782_() + "'!");
        }
        if (CommonProperties.get().debugInfo) {
            ConsoleJS.STARTUP.setLineNumber(true);
            ConsoleJS.STARTUP.info("~ " + this.registryKey.m_135782_() + " | " + builder.id);
            ConsoleJS.STARTUP.setLineNumber(false);
        }
        if (this.objects.containsKey(builder.id)) {
            throw new IllegalArgumentException("Duplicate key '" + builder.id + "' in registry '" + this.registryKey.m_135782_() + "'!");
        }
        this.objects.put(builder.id, builder);
        ALL_BUILDERS.add(builder);
    }

    @Nullable
    public BuilderType<T> getDefaultType() {
        if (this.types.isEmpty()) {
            return null;
        }
        if (this.defaultType == null) {
            this.defaultType = this.types.values().iterator().next();
        }
        return this.defaultType;
    }

    void postEvent(String id) {
        if (!this.types.isEmpty()) {
            new RegistryEventJS(this).post(id);
        }
    }

    static void registerAll(boolean all) {
        for (BuilderBase<?> builderBase : new ArrayList(ALL_BUILDERS)) {
            builderBase.createAdditionalObjects();
        }
        for (RegistryObjectBuilderTypes registryObjectBuilderTypes : MAP.values()) {
            boolean any = false;
            for (BuilderBase builder : registryObjectBuilderTypes.objects.values()) {
                if (!builder.registerObject(all)) continue;
                any = true;
            }
            if (!any) continue;
            registryObjectBuilderTypes.deferredRegister.register();
        }
    }

    @Nullable
    public BuilderBase<? extends T> getCurrent() {
        return this.current;
    }

    public record BuilderType<T>(String type, Class<? extends BuilderBase<? extends T>> builderClass, BuilderFactory<T> factory) {
    }

    public static interface BuilderFactory<T> {
        public BuilderBase<? extends T> createBuilder(ResourceLocation var1);
    }

    public static class RegistryEventJS<T>
    extends StartupEventJS {
        private final RegistryObjectBuilderTypes<T> registry;

        private RegistryEventJS(RegistryObjectBuilderTypes<T> r) {
            this.registry = r;
        }

        public BuilderBase<? extends T> create(String id, String type) {
            BuilderType t = this.registry.types.get(type);
            if (t == null) {
                throw new IllegalArgumentException("Unknown type '" + type + "' for object '" + id + "'!");
            }
            BuilderBase b = t.factory.createBuilder(UtilsJS.getMCID(KubeJS.appendModId(id)));
            if (b == null) {
                throw new IllegalArgumentException("Unknown type '" + type + "' for object '" + id + "'!");
            }
            this.registry.addBuilder(b);
            return b;
        }

        public BuilderBase<? extends T> create(String id) {
            BuilderType<T> t = this.registry.getDefaultType();
            if (t == null) {
                throw new IllegalArgumentException("Registry for type '" + this.registry.registryKey.m_135782_() + "' doesn't have any builders registered!");
            }
            BuilderBase b = t.factory.createBuilder(UtilsJS.getMCID(KubeJS.appendModId(id)));
            if (b == null) {
                throw new IllegalArgumentException("Unknown type '" + t.type + "' for object '" + id + "'!");
            }
            this.registry.addBuilder(b);
            return b;
        }
    }
}

