/*
 * Decompiled with CFR 0.152.
 */
package dev.trinsdar.bicclipboard.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.trinsdar.bicclipboard.BiCClipboard;
import dev.trinsdar.bicclipboard.BiCClipboardUtils;
import dev.trinsdar.bicclipboard.client.ClipboardEditBox;
import dev.trinsdar.bicclipboard.clipboard.CheckboxState;
import dev.trinsdar.bicclipboard.clipboard.ClipboardContent;
import dev.trinsdar.bicclipboard.clipboard.ClipboardSyncPacket;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClipboardScreen
extends Screen {
    private final ItemStack stack;
    private ClipboardContent data;
    private final CheckboxButton[] checkboxes = new CheckboxButton[9];
    private final ClipboardEditBox[] lines = new ClipboardEditBox[9];
    private ClipboardEditBox titleBox;
    private PageButton forwardButton;
    private PageButton backButton;

    public ClipboardScreen(ItemStack stack) {
        super(stack.m_41786_());
        this.stack = stack;
        this.data = ClipboardContent.fromStack(stack);
    }

    public void m_7379_() {
        super.m_7379_();
        ArrayList<ClipboardContent.Page> pages = new ArrayList<ClipboardContent.Page>(this.data.pages());
        for (int i = pages.size() - 1; i > 0 && i != this.data.active() && ((ClipboardContent.Page)pages.get(i)).equals(ClipboardContent.Page.DEFAULT); --i) {
            pages.remove(i);
        }
        this.data = this.data.setPages(pages);
        BiCClipboard.INSTANCE.sendToServer((Object)new ClipboardSyncPacket(this.data));
    }

    public void m_96624_() {
        this.titleBox.m_94120_();
        for (ClipboardEditBox box : this.lines) {
            box.m_94120_();
        }
    }

    protected void m_7856_() {
        int x = (this.f_96543_ - 192) / 2;
        this.titleBox = (ClipboardEditBox)this.m_142416_((GuiEventListener)new ClipboardEditBox(this.getMinecraft().f_91062_, x + 57, 14, 72, 8, (Component)new TextComponent("")));
        this.titleBox.m_94202_(0);
        this.titleBox.m_94182_(false);
        this.titleBox.m_94151_(e -> {
            this.data = this.data.setTitle((String)e);
        });
        for (int i = 0; i < 9; ++i) {
            int j = i;
            this.checkboxes[i] = (CheckboxButton)this.m_142416_((GuiEventListener)new CheckboxButton(x + 30, 15 * i + 26, e -> {
                ArrayList<ClipboardContent.Page> pages = new ArrayList<ClipboardContent.Page>(this.data.pages());
                ClipboardContent.Page page = (ClipboardContent.Page)pages.get(this.data.active());
                ArrayList<CheckboxState> checkboxes = new ArrayList<CheckboxState>(page.checkboxes());
                checkboxes.set(j, ((CheckboxButton)e).getState());
                pages.set(this.data.active(), page.setCheckboxes(checkboxes));
                this.data = this.data.setPages(pages);
            }));
            this.lines[i] = (ClipboardEditBox)this.m_142416_((GuiEventListener)new ClipboardEditBox(this.getMinecraft().f_91062_, x + 45, 15 * i + 28, 109, 8, (Component)new TextComponent("")));
            this.lines[i].m_94202_(0);
            this.lines[i].m_94182_(false);
            this.lines[i].m_94151_(e -> {
                ArrayList<ClipboardContent.Page> pages = new ArrayList<ClipboardContent.Page>(this.data.pages());
                ClipboardContent.Page page = (ClipboardContent.Page)pages.get(this.data.active());
                ArrayList<String> lines = new ArrayList<String>(page.lines());
                lines.set(j, (String)e);
                pages.set(this.data.active(), page.setLines(lines));
                this.data = this.data.setPages(pages);
            });
        }
        this.forwardButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(x + 116, 159, true, $ -> {
            this.data = this.data.nextPage();
            this.updateContents();
        }, false));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(x + 43, 159, false, $ -> {
            this.data = this.data.prevPage();
            this.updateContents();
        }, false));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, 196, 200, 20, CommonComponents.f_130655_, $ -> this.m_7379_()));
        this.updateContents();
    }

    public static void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)loc);
        ClipboardScreen.m_93133_((PoseStack)stack, (int)left, (int)top, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)textureSizeX, (int)textureSizeY);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        ClipboardScreen.drawTexture(stack, BiCClipboardUtils.BACKGROUND_GUI, (this.f_96543_ - 192) / 2, 2, 0, 0, 192, 192, 256, 256);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0 && this.forwardButton.f_93624_) {
            this.forwardButton.m_5691_();
            return true;
        }
        if (delta > 0.0 && this.backButton.f_93624_) {
            this.backButton.m_5691_();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7522_(@Nullable GuiEventListener listener) {
        if (listener != this.m_7222_()) {
            for (ClipboardEditBox box : this.lines) {
                if (box == listener && listener != null) continue;
                box.m_94178_(false);
            }
            if (this.titleBox != listener || listener == null) {
                this.titleBox.m_94178_(false);
            }
        }
        super.m_7522_(listener);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return switch (keyCode) {
            case 266 -> {
                this.backButton.m_5691_();
                yield true;
            }
            case 267 -> {
                this.forwardButton.m_5691_();
                yield true;
            }
            default -> false;
        };
    }

    private void updateContents() {
        this.backButton.f_93624_ = this.data.active() > 0;
        this.titleBox.m_94144_(this.data.title());
        ClipboardContent.Page page = this.data.pages().get(this.data.active());
        for (int i = 0; i < this.checkboxes.length; ++i) {
            this.checkboxes[i].setState(page.checkboxes().get(i));
            this.lines[i].m_94144_(page.lines().get(i));
        }
    }

    private static class CheckboxButton
    extends Button {
        private CheckboxState state = CheckboxState.EMPTY;

        public CheckboxButton(int x, int y, Button.OnPress onPress) {
            super(x, y, 14, 14, (Component)new TextComponent(""), onPress);
        }

        public CheckboxState getState() {
            return this.state;
        }

        public void setState(CheckboxState state) {
            this.state = state;
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.state = switch (this.state) {
                default -> throw new IncompatibleClassChangeError();
                case CheckboxState.EMPTY -> CheckboxState.CHECK;
                case CheckboxState.CHECK -> CheckboxState.X;
                case CheckboxState.X -> CheckboxState.EMPTY;
            };
            super.m_5716_(mouseX, mouseY);
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.getSprite() != null) {
                ClipboardScreen.drawTexture(poseStack, this.getSprite(), this.f_93620_, this.f_93621_, 0, 0, 14, 14, 14, 14);
            }
        }

        @Nullable
        protected ResourceLocation getSprite() {
            return switch (this.state) {
                default -> throw new IncompatibleClassChangeError();
                case CheckboxState.EMPTY -> null;
                case CheckboxState.CHECK -> BiCClipboardUtils.CHECK_TEXTURE;
                case CheckboxState.X -> BiCClipboardUtils.X_TEXTURE;
            };
        }
    }
}

