/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.color.ColorThief;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ColorGetter
implements IColorHelper {
    public static final ColorGetter INSTANCE = new ColorGetter();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] defaultColors = new String[]{"White:EEEEEE", "LightBlue:7492cc", "Cyan:00EEEE", "Blue:2222dd", "LapisBlue:25418b", "Teal:008080", "Yellow:cacb58", "GoldenYellow:EED700", "Orange:d97634", "Pink:D1899D", "HotPink:FC0FC0", "Magenta:b24bbb", "Purple:813eb9", "JadedPurple:43324f", "EvilPurple:2e1649", "Lavender:B57EDC", "Indigo:480082", "Sand:dbd3a0", "Tan:bb9b63", "LightBrown:A0522D", "Brown:634b33", "DarkBrown:3a2d13", "LimeGreen:43b239", "SlimeGreen:83cb73", "Green:008000", "DarkGreen:224d22", "GrassGreen:548049", "Red:963430", "BrickRed:b0604b", "NetherBrick:2a1516", "Redstone:ce3e36", "Black:181515", "CharcoalGray:464646", "IronGray:646464", "Gray:808080", "Silver:C0C0C0"};

    private ColorGetter() {
    }

    public static String[] getColorDefaults() {
        return defaultColors;
    }

    public static List<Integer> getColors(ItemStack itemStack, int colorCount) {
        try {
            return ColorGetter.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.debug("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private static List<Integer> unsafeGetColors(ItemStack itemStack, int colorCount) {
        Item item = itemStack.m_41720_();
        if (itemStack.m_41619_()) {
            return Collections.emptyList();
        }
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            Block block = itemBlock.m_40614_();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getBlockColors(block, colorCount);
        }
        return ColorGetter.getItemColors(itemStack, colorCount);
    }

    private static List<Integer> getItemColors(ItemStack itemStack, int colorCount) {
        ItemColors itemColors = Minecraft.m_91087_().getItemColors();
        int renderColor = itemColors.m_92676_(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Integer> getBlockColors(Block block, int colorCount) {
        BlockState blockState = block.m_49966_();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        int renderColor = blockColors.m_92577_(blockState, null, null, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    @Override
    public List<Integer> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        int[][] palette;
        if (colorCount <= 0) {
            return Collections.emptyList();
        }
        NativeImage bufferedImage = ColorGetter.getNativeImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
        for (int[] colorInt : palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false)) {
            int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
            int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
            int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
            red = Mth.m_14045_((int)red, (int)0, (int)255);
            green = Mth.m_14045_((int)green, (int)0, (int)255);
            blue = Mth.m_14045_((int)blue, (int)0, (int)255);
            int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
            colors.add(color);
        }
        return colors;
    }

    @Nullable
    private static NativeImage getNativeImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.m_118405_();
        int iconHeight = textureAtlasSprite.m_118408_();
        int frameCount = textureAtlasSprite.m_118415_();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        NativeImage[] frames = textureAtlasSprite.f_118342_;
        return frames[0];
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = minecraft.m_91289_();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.m_110907_();
        BakedModel blockModel = blockModelShapes.m_110893_(blockState);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        TextureAtlasSprite textureAtlasSprite = renderHelper.getParticleIcon(blockModel);
        if (textureAtlasSprite instanceof MissingTextureAtlasSprite) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemModelShaper itemModelMesher = itemRenderer.m_115103_();
        BakedModel itemModel = itemModelMesher.m_109406_(itemStack);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        TextureAtlasSprite particleTexture = renderHelper.getParticleIcon(itemModel);
        if (particleTexture instanceof MissingTextureAtlasSprite) {
            return null;
        }
        return particleTexture;
    }
}

