/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.item.custom;

import java.text.DecimalFormat;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AbstractNavItem
extends Item {
    public AbstractNavItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand, NavType navType) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        pPlayer.m_36335_().m_41524_((Item)this, 200);
        if (!pLevel.f_46443_) {
            Vec3 positionClicked = pPlayer.m_146892_();
            this.outputCoordinate(positionClicked, pPlayer, navType);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }

    public void outputCoordinate(Vec3 position, Player player, NavType navType) {
        String[] navStrings = AbstractNavItem.getNavStrings(position);
        Object locationText = navStrings[NavSelection.LATITUDE.ordinal()];
        Object simpleLocationText = navStrings[NavSelection.LAT_SIMPLE.ordinal()];
        TranslatableComponent copyMessage = new TranslatableComponent("copy_latitude");
        switch (navType) {
            case LAT: {
                break;
            }
            case LON: {
                locationText = navStrings[NavSelection.LONGITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.LON_SIMPLE.ordinal()];
                copyMessage = new TranslatableComponent("copy_longitude");
                break;
            }
            case ALT: {
                locationText = navStrings[NavSelection.ALTITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.ALT_SIMPLE.ordinal()];
                copyMessage = new TranslatableComponent("copy_altitude");
                break;
            }
            case LAT_LON: {
                locationText = navStrings[NavSelection.LATITUDE.ordinal()] + " | " + navStrings[NavSelection.LONGITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.LAT_SIMPLE.ordinal()] + ", " + navStrings[NavSelection.LON_SIMPLE.ordinal()];
                copyMessage = new TranslatableComponent("copy_latlon");
            }
        }
        String finalSimpleLocationText = simpleLocationText;
        TranslatableComponent finalCopyMessage = copyMessage;
        MutableComponent locationMessage = new TextComponent((String)locationText).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalSimpleLocationText)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)finalCopyMessage)));
        player.m_6352_((Component)locationMessage, player.m_142081_());
    }

    public static double[] getNavLocation(Vec3 position) {
        double latitude = Math.floor(position.m_82507_(Direction.Axis.Z) - 20000.0) / 40000.0 * 90.0;
        double longitude = Math.floor(position.m_82507_(Direction.Axis.X)) / 40000.0 * 90.0;
        double altitude = position.m_82507_(Direction.Axis.Y) - 64.0;
        return new double[]{latitude, longitude, altitude};
    }

    public static String[] getNavStrings(Vec3 position) {
        double randomScale = 0.1;
        int altRandomScale = 4;
        double[] navLocation = AbstractNavItem.getNavLocation(position);
        double latitude = navLocation[NavSelection.LATITUDE.ordinal()] + Math.random() * randomScale;
        double longitude = navLocation[NavSelection.LONGITUDE.ordinal()] + Math.random() * randomScale;
        double altitude = navLocation[NavSelection.ALTITUDE.ordinal()] + Math.random() * (double)altRandomScale;
        DecimalFormat dfAlt = new DecimalFormat("###");
        DecimalFormat df = new DecimalFormat("###.##");
        String latStr = "Latitude: " + df.format(Math.abs(latitude)) + " Degrees " + (latitude > 0.0 ? "South" : "North");
        String lonStr = "Longitude: " + df.format(Math.abs(longitude)) + " Degrees " + (longitude > 0.0 ? "East" : "West");
        String altStr = "Altitude: " + dfAlt.format(Math.abs(altitude)) + " Meters " + (altitude > 0.0 ? "Above" : "Below") + " Sea Level";
        String latSim = "Lat: " + df.format(Math.abs(latitude)) + " " + (latitude > 0.0 ? "S" : "N");
        String lonSim = "Lon: " + df.format(Math.abs(longitude)) + " " + (longitude > 0.0 ? "E" : "W");
        String altSim = "Alt: " + dfAlt.format(altitude);
        return new String[]{latStr, lonStr, altStr, latSim, lonSim, altSim};
    }

    public static enum NavType {
        LAT,
        LON,
        ALT,
        LAT_LON;

    }

    public static enum NavSelection {
        LATITUDE,
        LONGITUDE,
        ALTITUDE,
        LAT_SIMPLE,
        LON_SIMPLE,
        ALT_SIMPLE;

    }
}

