/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.stonelayer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.worldgen.IWorldgenObject;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerOre;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerRestrictions;
import org.jetbrains.annotations.Nullable;

public record StoneLayer(ResourceLocation id, @Nullable StoneType type, Block block, int weight, StoneLayerRestrictions restrictions, List<ResourceKey<Level>> dimensions, List<StoneLayerOre> ores) implements IWorldgenObject<StoneLayer>
{
    private static Int2ObjectOpenHashMap<List<StoneLayerOre>> COLLISION_MAP = new Int2ObjectOpenHashMap();
    public static final Codec<StoneLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(StoneLayer::id), (App)Registry.f_122824_.m_194605_().fieldOf("block").forGetter(StoneLayer::block), (App)Codec.INT.fieldOf("weight").forGetter(StoneLayer::weight), (App)StoneLayerRestrictions.CODEC.optionalFieldOf("restrictions", (Object)StoneLayerRestrictions.EMPTY).forGetter(StoneLayer::restrictions), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).listOf().fieldOf("dimensions").forGetter(StoneLayer::dimensions), (App)StoneLayerOre.CODEC.listOf().optionalFieldOf("ores", List.of()).forGetter(StoneLayer::ores)).apply((Applicative)instance, StoneLayer::new));

    public StoneLayer(ResourceLocation id, Block block, int weight, StoneLayerRestrictions restrictions, List<ResourceKey<Level>> dimensions, List<StoneLayerOre> ores) {
        this(id, StoneType.fromBlock(block), block, weight, restrictions, dimensions, ores);
    }

    @Override
    public ResourceLocation getLoc() {
        return this.id;
    }

    @Override
    public String getSubDirectory() {
        return "stone_layers";
    }

    @Override
    public Codec<StoneLayer> getCodec() {
        return CODEC;
    }

    @Override
    public List<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }

    public static void setCollisionMap(Int2ObjectOpenHashMap<List<StoneLayerOre>> collisionMap) {
        COLLISION_MAP = collisionMap;
    }

    public static List<StoneLayerOre> getCollision(StoneType middle, BlockState top, BlockState bottom) {
        if (middle == null) {
            return Collections.emptyList();
        }
        List list = (List)COLLISION_MAP.get(Objects.hash(top, bottom));
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }
}

