/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.TierSortingRegistry;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.behaviour.IAddInformation;
import org.gtreimagined.gtlib.behaviour.IBehaviour;
import org.gtreimagined.gtlib.behaviour.IBlockDestroyed;
import org.gtreimagined.gtlib.behaviour.IInteractEntity;
import org.gtreimagined.gtlib.behaviour.IItemHighlight;
import org.gtreimagined.gtlib.behaviour.IItemRightClick;
import org.gtreimagined.gtlib.behaviour.IItemUse;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IAbstractToolMethods;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public interface IBasicGTTool
extends IGTObject,
IColorHandler,
ITextureProvider,
IModelProvider,
IAbstractToolMethods {
    public GTToolType getGTToolType();

    public Tier getItemTier();

    default public String getTextureDomain() {
        return this.getDomain();
    }

    default public Item getItem() {
        return (Item)this;
    }

    default public Object2ObjectMap<String, IBehaviour<IBasicGTTool>> getBehaviours() {
        return this.getGTToolType().getBehaviours();
    }

    default public Set<TagKey<Block>> getActualTags() {
        return this.getGTToolType().getToolTypes();
    }

    default public CompoundTag getDataTag(ItemStack stack) {
        return stack.m_41737_("td");
    }

    default public CompoundTag getOrCreateDataTag(ItemStack stack) {
        return stack.m_41698_("td");
    }

    default public Tier getTier(ItemStack stack) {
        return this.getItemTier();
    }

    default public boolean genericIsCorrectToolForDrops(ItemStack stack, BlockState state) {
        GTToolType type = this.getGTToolType();
        boolean containsEffectiveBlock = false;
        if (type.getEffectiveMaterials().contains(state.m_60767_())) {
            containsEffectiveBlock = true;
        }
        if (type.getEffectiveBlocks().contains(state.m_60734_())) {
            containsEffectiveBlock = true;
        }
        for (TagKey<Block> effectiveBlockTag : type.getEffectiveBlockTags()) {
            if (!state.m_204336_(effectiveBlockTag)) continue;
            containsEffectiveBlock = true;
            break;
        }
        for (TagKey<Block> toolType : this.getGTToolType().getToolTypes()) {
            if (!state.m_204336_(toolType)) continue;
            containsEffectiveBlock = true;
            break;
        }
        return containsEffectiveBlock && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(stack), (BlockState)state);
    }

    default public float getDefaultMiningSpeed(ItemStack stack) {
        return this.getTier(stack).m_6624_() * this.getGTToolType().getMiningSpeedMultiplier();
    }

    default public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (this.getGTToolType().getTooltip().size() != 0) {
            tooltip.addAll(this.getGTToolType().getTooltip());
        }
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.mining_level", this.getTier(stack).m_6604_()).m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.tool_speed", Utils.literal("" + this.getDefaultMiningSpeed(stack)).m_130940_(ChatFormatting.LIGHT_PURPLE)));
        for (Map.Entry e : this.getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IAddInformation)) continue;
            IAddInformation addInformation = (IAddInformation)b;
            addInformation.onAddInformation(this, stack, tooltip, flag);
        }
    }

    default public boolean onGenericHitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker, float volume, float pitch) {
        if (this.getGTToolType().getUseSound() != null) {
            target.m_20193_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getGTToolType().getUseSound(), SoundSource.HOSTILE, volume, pitch);
        }
        Utils.damageStack(this.getGTToolType().getAttackDurability(), stack, attacker);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            this.refillTool(stack, player);
        }
        return true;
    }

    default public boolean onGenericBlockDestroyed(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (entity instanceof Player) {
            boolean isToolEffective;
            Player player = (Player)entity;
            if (this.getGTToolType().getUseSound() != null) {
                player.m_6330_(this.getGTToolType().getUseSound(), SoundSource.BLOCKS, 0.84f, 0.75f);
            }
            boolean isPlant = GTAPI.isModLoaded("tfc") && (this.getGTToolType() == GTTools.KNIFE || this.getGTToolType() == GTTools.SCYTHE) && state.m_204336_(TagUtils.getBlockTag(new ResourceLocation("tfc", "plants")));
            boolean bl = isToolEffective = isPlant || this.genericIsCorrectToolForDrops(stack, state);
            if (state.m_60800_((BlockGetter)world, pos) != 0.0f || isPlant) {
                int damage = isToolEffective ? this.getGTToolType().getUseDurability() : this.getGTToolType().getUseDurability() + 1;
                Utils.damageStack(damage, stack, entity);
            }
        }
        boolean returnValue = true;
        for (Map.Entry e : this.getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IBlockDestroyed)) continue;
            returnValue = ((IBlockDestroyed)b).onBlockDestroyed(this, stack, world, state, pos, entity);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.refillTool(stack, player);
        }
        return returnValue;
    }

    default public void refillTool(ItemStack stack, Player player) {
    }

    default public InteractionResult genericInteractLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        InteractionResult result = InteractionResult.PASS;
        for (Map.Entry e : this.getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IInteractEntity)) continue;
            IInteractEntity interactEntity = (IInteractEntity)b;
            InteractionResult r = interactEntity.interactLivingEntity(this, stack, player, interactionTarget, usedHand);
            if (result == InteractionResult.SUCCESS) continue;
            result = r;
        }
        return result;
    }

    default public InteractionResult onGenericItemUse(UseOnContext ctx) {
        InteractionResult result = InteractionResult.PASS;
        for (Map.Entry e : this.getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IItemUse)) continue;
            IItemUse itemUse = (IItemUse)b;
            InteractionResult r = itemUse.onItemUse(this, ctx);
            if (result == InteractionResult.SUCCESS) continue;
            result = r;
        }
        return result;
    }

    default public InteractionResultHolder<ItemStack> onGenericRightclick(Level level, Player player, InteractionHand usedHand) {
        for (Map.Entry e : this.getBehaviours().entrySet()) {
            IItemRightClick rightClick;
            InteractionResultHolder<ItemStack> r;
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IItemRightClick) || !(r = (rightClick = (IItemRightClick)b).onRightClick(this, level, player, usedHand)).m_19089_().m_146666_()) continue;
            return r;
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
    }

    default public InteractionResult onGenericHighlight(Player player, LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        InteractionResult result = InteractionResult.PASS;
        for (Map.Entry e : this.getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IItemHighlight)) continue;
            InteractionResult type = ((IItemHighlight)b).onDrawHighlight(player, levelRenderer, camera, target, partialTicks, poseStack, multiBufferSource);
            if (type != InteractionResult.SUCCESS) {
                result = type;
                continue;
            }
            return InteractionResult.FAIL;
        }
        return result;
    }

    default public boolean hasEnoughDurability(ItemStack stack, int damage, boolean energy) {
        return true;
    }
}

