/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.structure;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityHatch;
import org.gtreimagined.gtlib.capability.IComponentHandler;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.HatchMachine;
import org.gtreimagined.gtlib.structure.IComponent;

public class GTLibStructureUtility {
    public static <T extends BlockEntityBasicMultiMachine<T>> IStructureElement<T> ofHatch(HatchMachine machine) {
        return GTLibStructureUtility.ofHatch(machine, (t, world, pos, machine1, handler) -> {
            t.addComponent(machine1.getId(), handler);
            return true;
        });
    }

    public static <T extends BlockEntityBasicMultiMachine<T>> IStructureElement<T> ofHatchMinTier(HatchMachine machine, Tier minTier) {
        return GTLibStructureUtility.ofHatch(machine, (t, world, pos, machine1, handler) -> {
            BlockEntity patt1221$temp = handler.getTile();
            if (!(patt1221$temp instanceof BlockEntityMachine)) {
                return false;
            }
            BlockEntityMachine machineTile = (BlockEntityMachine)patt1221$temp;
            if (machineTile.getMachineTier().getVoltage() < minTier.getVoltage()) {
                return false;
            }
            t.addComponent(machine1.getIdForHandlers(), handler);
            return true;
        });
    }

    public static <T extends BlockEntityBasicMultiMachine<T>> IStructureElement<T> ofHatch(final HatchMachine machine, final IHatchStructurePredicate<T> callback) {
        return new IStructureElement<T>(){

            public boolean check(T t, Level world, int x, int y, int z) {
                IComponent component;
                BlockPos pos = new BlockPos(x, y, z);
                BlockEntity tile = world.m_7702_(pos);
                if (tile instanceof IComponent && (component = (IComponent)tile).getComponentHandler().isPresent()) {
                    IComponentHandler componentHandler = component.getComponentHandler().orElse(null);
                    if (machine.getIdForHandlers().equals(componentHandler.getIdForHandlers())) {
                        BlockEntity blockEntity;
                        boolean test = callback.test(t, world, pos, machine, componentHandler);
                        if (test && (blockEntity = world.m_7702_(pos)) instanceof BlockEntityHatch) {
                            BlockEntityHatch hatch = (BlockEntityHatch)blockEntity;
                            hatch.setTextureBlock(((BlockEntityBasicMultiMachine)t).getHatchBlock(pos));
                        }
                        return test;
                    }
                    return false;
                }
                return false;
            }

            public boolean spawnHint(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return false;
            }

            public boolean placeBlock(T t, Level world, int x, int y, int z, ItemStack trigger) {
                return false;
            }

            public void onStructureFail(T t, Level world, int x, int y, int z) {
                BlockEntity blockEntity = world.m_7702_(new BlockPos(x, y, z));
                if (blockEntity instanceof BlockEntityHatch) {
                    BlockEntityHatch hatch = (BlockEntityHatch)blockEntity;
                    hatch.setTextureBlock(null);
                }
            }
        };
    }

    public static interface IHatchStructurePredicate<T> {
        public boolean test(T var1, Level var2, BlockPos var3, HatchMachine var4, IComponentHandler var5);
    }
}

