/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.recipe.material.MaterialRecipe;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.TagUtils;
import org.jetbrains.annotations.NotNull;

public class RecipeBuilders {
    public static final MaterialRecipe.Provider PROBE_BUILDER = MaterialRecipe.registerProvider("probe", "gtlib", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Object h = mats.mats.get("helmet");
            ItemStack helmet = ((ItemStack)h).m_41777_();
            CompoundTag nbt = helmet.m_41784_();
            if (nbt.m_128441_("theoneprobe") && nbt.m_128471_("theoneprobe")) {
                return ItemStack.f_41583_;
            }
            nbt.m_128379_("theoneprobe", true);
            return helmet;
        }

        @Override
        public Map<String, Object> getFromResult(@NotNull ItemStack stack) {
            return ImmutableMap.of();
        }
    });
    public static final MaterialRecipe.Provider CROWBAR_BUILDER = MaterialRecipe.registerProvider("crowbar", "gtlib", id -> new MaterialRecipe.ItemBuilder(){

        @Override
        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            int dye = ((DyeColor)mats.mats.get((Object)"secondary")).m_41069_().f_76396_;
            IGTTool type = GTAPI.get(IGTTool.class, id, "antimatter_shared");
            ItemStack stack = type.asItemStack(type.getGTItemTier().getPrimary(), Material.NULL);
            stack.m_41698_("td").m_128405_("sc", dye);
            return stack;
        }

        @Override
        public Map<String, Object> getFromResult(@NotNull ItemStack stack) {
            CompoundTag nbt = stack.m_41783_().m_128469_("td");
            int secondary = nbt.m_128451_("sc");
            Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(t -> t.m_41069_().f_76396_ == secondary).findFirst();
            return ImmutableMap.of((Object)"secondary", (Object)(color.isEmpty() ? Material.NULL : color.get()));
        }
    });

    public static void init() {
    }

    public static DyeColor getColor(ItemStack stack) {
        if (stack.m_41720_() instanceof DyeItem) {
            return ((DyeItem)stack.m_41720_()).m_41089_();
        }
        for (int i = 0; i < 15; ++i) {
            DyeColor color = DyeColor.m_41053_((int)i);
            String colorString = color.m_41065_();
            if (stack.m_204117_(TagUtils.getForgelikeItemTag("dyes/" + colorString))) {
                return color;
            }
            if (!stack.m_204117_(TagUtils.getForgelikeItemTag(colorString + "_dyes"))) continue;
            return color;
        }
        return null;
    }

    static {
        PropertyIngredient.addGetter(TagUtils.getForgelikeItemTag("dyes").f_203868_(), RecipeBuilders::getColor);
    }
}

