/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.network.packets;

import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.ICoverHandlerProvider;
import org.gtreimagined.gtlib.gui.container.IGTContainer;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.util.Utils;

public class CoverGuiEventPacket
extends AbstractGuiEventPacket<CoverGuiEventPacket> {
    public static final PacketHandler<CoverGuiEventPacket> HANDLER = new Handler();
    Direction facing;

    public CoverGuiEventPacket(IGuiEvent event, BlockPos pos, Direction facing) {
        super(event, pos, GTLibNetwork.COVER_GUI_PACKET_ID);
        this.facing = facing;
    }

    public PacketHandler<CoverGuiEventPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<CoverGuiEventPacket> {
        private Handler() {
        }

        public void encode(CoverGuiEventPacket msg, FriendlyByteBuf buf) {
            msg.event.getFactory().write(msg.event, buf);
            buf.m_130064_(msg.pos);
            buf.m_130068_((Enum)msg.facing);
        }

        public CoverGuiEventPacket decode(FriendlyByteBuf buf) {
            return new CoverGuiEventPacket(IGuiEvent.IGuiEventFactory.read(buf), buf.m_130135_(), (Direction)buf.m_130066_(Direction.class));
        }

        public PacketContext handle(CoverGuiEventPacket msg) {
            return (sender, level) -> {
                if (sender != null) {
                    BlockEntity tile = Utils.getTile((BlockGetter)sender.m_183503_(), msg.pos);
                    if (!(tile instanceof ICoverHandlerProvider)) {
                        throw new RuntimeException("Somehow you got an incorrect packet, CoverGuiEventPacket::handleClient missing Entity!");
                    }
                    ICoverHandlerProvider provider = (ICoverHandlerProvider)tile;
                    Optional<ICoverHandler<ICoverHandler>> coverHandler = provider.getCoverHandler();
                    if (msg.event.forward()) {
                        coverHandler.ifPresent(ch -> ch.get(msg.facing).onGuiEvent(msg.event, sender));
                    } else {
                        msg.event.handle(sender, ((IGTContainer)sender.f_36096_).source());
                    }
                }
            };
        }
    }
}

