/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.mixin;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.util.Utils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChestBlock.class})
public abstract class ChestBlockMixin
extends AbstractChestBlock<ChestBlockEntity> {
    @Shadow
    @Final
    public static EnumProperty<ChestType> f_51479_;

    protected ChestBlockMixin(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityFactory) {
        super(properties, blockEntityFactory);
    }

    @Inject(method={"getShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        Player player;
        EntityCollisionContext collisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (collisionContext = (EntityCollisionContext)context).m_193113_()) instanceof Player && Utils.isPlayerHolding(player = (Player)entity, InteractionHand.MAIN_HAND, GTTools.WRENCH)) {
            cir.setReturnValue((Object)Shapes.m_83144_());
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (!level.f_46443_ && Utils.isPlayerHolding(player, hand, GTTools.WRENCH)) {
            Direction side = Utils.getInteractSide(hit);
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            if (side.m_122434_().m_122479_()) {
                BlockState other;
                if (state.m_61143_(f_51479_) == ChestType.SINGLE) {
                    BlockState other2;
                    if (side == facing.m_122428_() && (other2 = level.m_8055_(pos.m_142300_(facing.m_122428_()))).m_60734_() == this && other2.m_61138_(f_51479_) && other2.m_61143_(f_51479_) == ChestType.SINGLE && other2.m_61143_((Property)BlockStateProperties.f_61374_) == facing) {
                        level.m_46597_(pos, (BlockState)state.m_61124_(f_51479_, (Comparable)ChestType.RIGHT));
                        level.m_46597_(pos.m_142300_(facing.m_122428_()), (BlockState)other2.m_61124_(f_51479_, (Comparable)ChestType.LEFT));
                        Utils.damageStack(player.m_21120_(hand), hand, (LivingEntity)player);
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        return;
                    }
                    if (side == facing.m_122427_() && (other2 = level.m_8055_(pos.m_142300_(facing.m_122427_()))).m_60734_() == this && other2.m_61138_(f_51479_) && other2.m_61143_(f_51479_) == ChestType.SINGLE && other2.m_61143_((Property)BlockStateProperties.f_61374_) == facing) {
                        level.m_46597_(pos, (BlockState)state.m_61124_(f_51479_, (Comparable)ChestType.LEFT));
                        level.m_46597_(pos.m_142300_(facing.m_122427_()), (BlockState)other2.m_61124_(f_51479_, (Comparable)ChestType.RIGHT));
                        Utils.damageStack(player.m_21120_(hand), hand, (LivingEntity)player);
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        return;
                    }
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)side));
                    Utils.damageStack(player.m_21120_(hand), hand, (LivingEntity)player);
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                } else if (state.m_61143_(f_51479_) == ChestType.LEFT) {
                    BlockState other3;
                    if (side == facing.m_122427_() && (other3 = level.m_8055_(pos.m_142300_(facing.m_122427_()))).m_60734_() == this && other3.m_61138_(f_51479_) && other3.m_61143_(f_51479_) == ChestType.RIGHT && other3.m_61143_((Property)BlockStateProperties.f_61374_) == facing) {
                        level.m_46597_(pos, (BlockState)state.m_61124_(f_51479_, (Comparable)ChestType.SINGLE));
                        level.m_46597_(pos.m_142300_(facing.m_122427_()), (BlockState)other3.m_61124_(f_51479_, (Comparable)ChestType.SINGLE));
                        Utils.damageStack(player.m_21120_(hand), hand, (LivingEntity)player);
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                    }
                } else if (state.m_61143_(f_51479_) == ChestType.RIGHT && side == facing.m_122428_() && (other = level.m_8055_(pos.m_142300_(facing.m_122428_()))).m_60734_() == this && other.m_61138_(f_51479_) && other.m_61143_(f_51479_) == ChestType.LEFT && other.m_61143_((Property)BlockStateProperties.f_61374_) == facing) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(f_51479_, (Comparable)ChestType.SINGLE));
                    level.m_46597_(pos.m_142300_(facing.m_122428_()), (BlockState)other.m_61124_(f_51479_, (Comparable)ChestType.SINGLE));
                    Utils.damageStack(player.m_21120_(hand), hand, (LivingEntity)player);
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }
}

