/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.machine;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.registration.IGTObject;

public enum MachineState implements IGTObject,
StringRepresentable
{
    IDLE(0, "Idle", true, false, true),
    DISABLED(0, "Disabled", false, false, true),
    ACTIVE(1, "Active", true, false, true),
    INVALID_STRUCTURE(2, "Structure is Invalid", false, false, true),
    INVALID_TIER(2, "Recipe Tier is Invalid", true, false, false),
    OUTPUT_FULL(2, "Output Slots are Full", false, true, false),
    NO_POWER(2, "No Power", false, false, false),
    POWER_LOSS(2, "Power Loss", true, false, false);

    public static final MachineState[] VALUES;
    private final int overlayId;
    private final String displayName;
    private final boolean recipeCheck;
    private final boolean loopTick;
    private final boolean renderUpdate;

    private MachineState(int overlayId, String displayName, boolean recipeCheck, boolean loopTick, boolean renderUpdate) {
        this.overlayId = overlayId;
        this.displayName = displayName;
        this.recipeCheck = recipeCheck;
        this.loopTick = loopTick;
        this.renderUpdate = renderUpdate;
        GTAPI.register(MachineState.class, this);
    }

    public int getOverlayId() {
        return this.overlayId;
    }

    public boolean allowRecipeCheck() {
        return this.recipeCheck;
    }

    public boolean allowLoopTick() {
        return this.loopTick;
    }

    public boolean allowRenderUpdate() {
        return this.renderUpdate;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getId() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public MachineState getTextureState() {
        switch (this) {
            case ACTIVE: 
            case INVALID_STRUCTURE: {
                return this;
            }
        }
        return IDLE;
    }

    public static void init() {
    }

    public String m_7912_() {
        return this.getId();
    }

    static {
        VALUES = MachineState.values();
    }
}

