/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei;

import java.util.List;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.container.ContainerBasicMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;

public class MachineTransferHandler
implements IRecipeTransferInfo<ContainerBasicMachine, IRecipe> {
    final ResourceLocation id;

    public MachineTransferHandler(ResourceLocation id) {
        this.id = id;
    }

    public Class<ContainerBasicMachine> getContainerClass() {
        return ContainerBasicMachine.class;
    }

    public boolean canHandle(ContainerBasicMachine container, IRecipe recipe) {
        String name;
        String[] split = recipe.getMapId().split(":");
        if (split.length == 2) {
            name = split[1];
        } else if (split.length == 1) {
            name = split[0];
        } else {
            return false;
        }
        IRecipeMap rmap = GTAPI.get(IRecipeMap.class, name);
        if (rmap == null) {
            return false;
        }
        Machine<?> machine = ((BlockEntityMachine)container.getTile()).getMachineType();
        if (machine.getRecipeMap(((BlockEntityMachine)container.getTile()).getMachineTier()) == null || machine.getRecipeMap(((BlockEntityMachine)container.getTile()).getMachineTier()) != rmap) {
            return false;
        }
        if (!recipe.hasInputItems()) {
            return false;
        }
        return container.slotMap.containsKey(SlotType.IT_IN);
    }

    public List<Slot> getRecipeSlots(ContainerBasicMachine container, IRecipe recipe) {
        return (List)container.slotMap.get(SlotType.IT_IN);
    }

    public List<Slot> getInventorySlots(ContainerBasicMachine container, IRecipe recipe) {
        return container.playerSlots;
    }

    public RecipeType<IRecipe> getRecipeType() {
        return new RecipeType(this.getRecipeCategoryUid(), this.getRecipeClass());
    }

    public Class<IRecipe> getRecipeClass() {
        return IRecipe.class;
    }

    public ResourceLocation getRecipeCategoryUid() {
        return this.id;
    }
}

