/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.fluid.IFluidNode;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.tesseract.api.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FluidHandler<T extends BlockEntityBase>
implements IMachineHandler,
IFluidNode,
Serializable {
    protected final T tile;
    protected final EnumMap<FluidDirection, FluidTanks> tanks = new EnumMap(FluidDirection.class);
    protected int capacity;
    protected boolean dirty;

    public FluidHandler(T tile, int capacity, int inputCount, int outputCount) {
        this.tile = tile;
        this.capacity = capacity;
        if (inputCount > 0) {
            this.tanks.put(FluidDirection.INPUT, FluidTanks.create(tile, SlotType.FL_IN, b -> {
                for (int i = 0; i < inputCount; ++i) {
                    b.tank(capacity);
                }
                return b;
            }));
        }
        if (outputCount > 0) {
            this.tanks.put(FluidDirection.OUTPUT, FluidTanks.create(tile, SlotType.FL_OUT, b -> {
                for (int i = 0; i < outputCount; ++i) {
                    b.tank(capacity);
                }
                return b;
            }));
        }
    }

    public void onRemove() {
    }

    public void onReset() {
    }

    public void onUpdate() {
    }

    public int getTanks() {
        return this.tanks.values().stream().mapToInt(FluidTanks::getTanks).sum();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getTank(tank).getFluid();
    }

    protected FluidTank getTank(int tank) {
        FluidTanks tanks = this.getTanks(tank);
        if (tanks == null) {
            return null;
        }
        return tanks.getTank(this.offsetTank(tank));
    }

    protected FluidTanks getTanks(int tank) {
        boolean isOutput;
        boolean hasOutput;
        FluidTanks input = this.getInputTanks();
        FluidTanks output = this.getOutputTanks();
        boolean hasInput = input != null;
        boolean bl = hasOutput = output != null;
        if (hasInput && !hasOutput) {
            return input;
        }
        if (!hasInput && hasOutput) {
            return output;
        }
        if (!hasOutput && !hasOutput) {
            return null;
        }
        boolean bl2 = isOutput = tank >= input.getTanks();
        if (!isOutput) {
            return input;
        }
        return output;
    }

    public int offsetTank(int tank) {
        FluidTanks in = this.getInputTanks();
        if (in != null && tank >= this.getInputTanks().getTanks()) {
            return tank - in.getTanks();
        }
        return tank;
    }

    public int getTankCapacity(int tank) {
        return this.getTanks(tank).getTankCapacity(this.offsetTank(tank));
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.getTank(tank).isFluidValid(stack);
    }

    public FluidTanks getAllTanks() {
        ObjectArrayList list = new ObjectArrayList();
        if (this.getInputTanks() != null) {
            list.addAll(Arrays.asList(this.getInputTanks().getBackingTanks()));
        }
        if (this.getOutputTanks() != null) {
            list.addAll(Arrays.asList(this.getOutputTanks().getBackingTanks()));
        }
        return new FluidTanks((Collection<FluidTank>)list);
    }

    public int fill(FluidStack fluid, IFluidHandler.FluidAction action) {
        FluidTanks input = this.getInputTanks();
        if (input != null && !this.empty(input)) {
            return this.getInputTanks().fill(fluid, action);
        }
        return 0;
    }

    protected boolean empty(FluidTanks tank) {
        return tank.getTanks() == 0;
    }

    public int fillOutput(FluidStack stack, IFluidHandler.FluidAction action) {
        if (this.getOutputTanks() != null) {
            return this.getOutputTanks().fill(stack, action);
        }
        return 0;
    }

    public FluidStack drain(FluidStack fluid, IFluidHandler.FluidAction action) {
        if (this.getOutputTanks() != null) {
            return this.getOutputTanks().drain(fluid, action);
        }
        return FluidStack.EMPTY;
    }

    @Override
    @NotNull
    public FluidStack drain(int toExtract, IFluidHandler.FluidAction action) {
        if (this.getOutputTanks() != null) {
            return this.getOutputTanks().drain(toExtract, action);
        }
        return FluidStack.EMPTY;
    }

    @Override
    @NotNull
    public FluidStack drainInput(FluidStack stack, IFluidHandler.FluidAction action) {
        if (this.getInputTanks() != null) {
            return this.getInputTanks().drain(stack, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainInput(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.getInputTanks() != null) {
            return this.getInputTanks().drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public void setFluid(int slot, FluidStack fluid) {
        this.getTank(slot).setFluid(fluid);
    }

    protected boolean checkValidFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
    }

    @NotNull
    public FluidStack[] getInputs() {
        FluidTanks tanks = this.getInputTanks();
        return tanks == null ? new FluidStack[]{} : (FluidStack[])tanks.getFluids().toArray(FluidStack[]::new);
    }

    public FluidStack[] getOutputs() {
        FluidTanks tanks = this.getOutputTanks();
        return tanks == null ? new FluidStack[]{} : (FluidStack[])tanks.getFluids().toArray(FluidStack[]::new);
    }

    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> list = new ArrayList<FluidStack>();
        list.addAll(Arrays.asList(this.getInputs()));
        list.addAll(Arrays.asList(this.getOutputs()));
        return list;
    }

    public boolean isEmpty() {
        return this.getAllTanks().isEmpty();
    }

    @Nullable
    public FluidTanks getInputTanks() {
        return this.tanks.get((Object)FluidDirection.INPUT);
    }

    @Nullable
    public FluidTanks getOutputTanks() {
        return this.tanks.get((Object)FluidDirection.OUTPUT);
    }

    @Override
    public boolean canOutput() {
        return this.getOutputTanks() != null;
    }

    @Override
    public boolean canInput() {
        return this.getInputTanks() != null;
    }

    @Override
    public boolean canInput(Direction direction) {
        return this.canInput();
    }

    @Override
    public boolean canInput(FluidStack fluid, Direction direction) {
        return true;
    }

    @Override
    public boolean canOutput(Direction direction) {
        return this.canOutput();
    }

    @Override
    public int getPriority(Direction direction) {
        return 0;
    }

    public String toString() {
        FluidStack stack;
        int i;
        StringBuilder builder = new StringBuilder();
        if (this.tanks.containsKey((Object)FluidDirection.INPUT)) {
            builder.append("Inputs:\n");
            for (i = 0; i < this.getInputTanks().getTanks(); ++i) {
                stack = this.getInputTanks().getFluidInTank(i);
                if (stack.isEmpty()) continue;
                builder.append(RegistryUtils.getIdFromFluid(stack.getFluid())).append(" - ").append(stack.getAmount());
                if (i == this.getInputTanks().getTanks() - 1) continue;
                builder.append("\n");
            }
        }
        if (this.tanks.containsKey((Object)FluidDirection.OUTPUT)) {
            builder.append("Outputs:\n");
            for (i = 0; i < this.getOutputTanks().getTanks(); ++i) {
                stack = this.getOutputTanks().getFluidInTank(i);
                if (stack.isEmpty()) continue;
                builder.append(RegistryUtils.getIdFromFluid(stack.getFluid())).append(" - ").append(stack.getAmount());
                if (i == this.getOutputTanks().getTanks() - 1) continue;
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public void deserialize(CompoundTag nbt) {
        this.tanks.forEach((k, v) -> {
            if (!nbt.m_128441_(k.toString())) {
                return;
            }
            v.deserialize(nbt.m_128437_(k.toString(), 10));
        });
    }

    public CompoundTag serialize(CompoundTag nbt) {
        this.tanks.forEach((k, v) -> nbt.m_128365_(k.name(), (Tag)v.serialize()));
        return nbt;
    }

    @Generated
    public T getTile() {
        return this.tile;
    }

    public static enum FluidDirection {
        INPUT,
        OUTPUT;

    }
}

