/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.single;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.EnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;

public class BlockEntityInfiniteStorage<T extends BlockEntityInfiniteStorage<T>>
extends BlockEntityMachine<T>
implements IInfoRenderer<InfiniteStorageWidget> {
    public BlockEntityInfiniteStorage(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, Long.MAX_VALUE, Long.MAX_VALUE, 0L, 32L, 0, 4){

            @Override
            public long extractEu(long voltage, boolean simulate) {
                return Math.min(voltage, this.getOutputVoltage());
            }

            @Override
            public boolean canOutput(Direction direction) {
                return ((BlockEntityInfiniteStorage)this.tile).getFacing() == direction;
            }
        });
    }

    @Override
    protected boolean allowExplosionsInRain() {
        return false;
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            int[] data = ((GuiEvents.GuiEvent)event).data;
            this.energyHandler.ifPresent(h -> {
                int voltage = (int)h.getOutputVoltage();
                int amperage = (int)h.getOutputAmperage();
                boolean shiftHold = data[0] != 0;
                switch (data[1]) {
                    case 0: {
                        voltage /= shiftHold ? 512 : 64;
                        break;
                    }
                    case 1: {
                        voltage -= shiftHold ? 512 : 64;
                        break;
                    }
                    case 2: {
                        amperage /= shiftHold ? 512 : 64;
                        break;
                    }
                    case 3: {
                        amperage -= shiftHold ? 512 : 64;
                        break;
                    }
                    case 4: {
                        voltage /= shiftHold ? 16 : 2;
                        break;
                    }
                    case 5: {
                        voltage -= shiftHold ? 16 : 1;
                        break;
                    }
                    case 6: {
                        amperage /= shiftHold ? 16 : 2;
                        break;
                    }
                    case 7: {
                        amperage -= shiftHold ? 16 : 1;
                        break;
                    }
                    case 8: {
                        voltage += shiftHold ? 512 : 64;
                        break;
                    }
                    case 9: {
                        voltage *= shiftHold ? 512 : 64;
                        break;
                    }
                    case 10: {
                        amperage += shiftHold ? 512 : 64;
                        break;
                    }
                    case 11: {
                        amperage *= shiftHold ? 512 : 64;
                        break;
                    }
                    case 12: {
                        voltage += shiftHold ? 16 : 1;
                        break;
                    }
                    case 13: {
                        voltage *= shiftHold ? 16 : 2;
                        break;
                    }
                    case 14: {
                        amperage += shiftHold ? 16 : 1;
                        break;
                    }
                    case 15: {
                        amperage *= shiftHold ? 16 : 2;
                    }
                }
                if (voltage < 0) {
                    voltage = 0;
                }
                if (amperage < 0) {
                    amperage = 0;
                }
                h.setOutputVoltage(voltage);
                h.setOutputAmperage(amperage);
            });
        }
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> info = super.getInfo(simple);
        this.energyHandler.ifPresent(h -> {
            info.add("Voltage Out: " + h.getOutputVoltage());
            info.add("Amperage Out: " + h.getOutputAmperage());
        });
        return info;
    }

    @Override
    public int drawInfo(InfiniteStorageWidget widget, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, "Control Panel", (float)(left + 43), (float)(top + 21), 0xFAFAFF);
        renderer.m_92883_(stack, "VOLT: " + widget.voltage, (float)(left + 43), (float)(top + 40), 0xFAFAFF);
        renderer.m_92883_(stack, "TIER: " + Tier.getTier(widget.voltage < 0L ? -widget.voltage : widget.voltage).getId().toUpperCase(), (float)(left + 43), (float)(top + 48), 0xFAFAFF);
        renderer.m_92883_(stack, "AMP: " + widget.amperage, (float)(left + 43), (float)(top + 56), 0xFAFAFF);
        renderer.m_92883_(stack, "SUM: " + (long)widget.amperage * widget.voltage, (float)(left + 43), (float)(top + 64), 0xFAFAFF);
        return 72;
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(InfiniteStorageWidget.build());
    }

    public static class InfiniteStorageWidget
    extends InfoRenderWidget<InfiniteStorageWidget> {
        public int amperage = 0;
        public long voltage = 0L;

        protected InfiniteStorageWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfiniteStorageWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            BlockEntityInfiniteStorage m = (BlockEntityInfiniteStorage)this.gui.handler;
            this.gui.syncInt(() -> Math.toIntExact(m.energyHandler.map(EnergyHandler::getOutputAmperage).orElse(0L)), i -> {
                this.amperage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> m.energyHandler.map(EnergyHandler::getOutputVoltage).orElse(0L), i -> {
                this.voltage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return InfiniteStorageWidget.builder((a, b) -> new InfiniteStorageWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }
}

