/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.pipe;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.pipe.BlockCable;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.tesseract.api.eu.EUGrid;
import org.gtreimagined.tesseract.api.eu.EUHolder;
import org.gtreimagined.tesseract.api.eu.EUNetwork;
import org.gtreimagined.tesseract.api.eu.IEUCable;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.gtreimagined.tesseract.graph.IElement;

public class BlockEntityCable<T extends PipeType<T>>
extends BlockEntityPipe<T>
implements IEUCable {
    private long holder;
    private EUNetwork network;

    public BlockEntityCable(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onLoad() {
        this.holder = EUHolder.create((IEUCable)this, (long)0L);
        super.onLoad();
    }

    @Override
    protected void register() {
        EUGrid.INSTANCE.addElement((IElement)this);
    }

    @Override
    protected boolean deregister() {
        EUGrid.INSTANCE.removeElement((IElement)this);
        return true;
    }

    @Override
    public Class<?> getCapClass() {
        return IEnergyHandler.class;
    }

    public long getVoltage() {
        return ((Cable)this.getPipeType()).getTier().getVoltage();
    }

    public boolean insulated() {
        return ((BlockCable)this.m_58900_().m_60734_()).insulated;
    }

    public long getHolder() {
        return this.holder;
    }

    public void setHolder(long holder) {
        this.holder = holder;
    }

    public double getLoss() {
        return ((Cable)this.getPipeType()).getLoss();
    }

    public int getAmps() {
        return ((Cable)this.getPipeType()).getAmps(this.getPipeSize());
    }

    @Override
    public boolean connects(Direction direction) {
        return this.canConnect(direction.m_122411_());
    }

    @Override
    public boolean validate(Direction dir) {
        if (!super.validate(dir)) {
            return false;
        }
        BlockEntity tile = this.getCachedBlockEntity(dir);
        if (tile == null) {
            return false;
        }
        return tile instanceof IEUCable || tile.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY, dir.m_122424_()).isPresent();
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
    }

    public void getNeighbours(Collection<IEUCable> neighbours) {
        for (Direction dir : Direction.values()) {
            IEUCable cable;
            BlockEntity pipe = this.getCachedBlockEntity(dir);
            if (!(pipe instanceof IEUCable) || !(cable = (IEUCable)pipe).connects(dir.m_122424_()) || !this.connects(dir)) continue;
            neighbours.add(cable);
        }
    }

    public EUNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(EUNetwork network) {
        this.network = network;
    }
}

