/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.multi;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ComponentHandler;
import org.gtreimagined.gtlib.capability.machine.HatchComponentHandler;
import org.gtreimagined.gtlib.capability.machine.MachineCoverHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.cover.CoverDynamo;
import org.gtreimagined.gtlib.cover.CoverEnergy;
import org.gtreimagined.gtlib.cover.CoverOutput;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.machine.types.HatchMachine;
import org.gtreimagined.gtlib.structure.IComponent;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class BlockEntityHatch<T extends BlockEntityHatch<T>>
extends BlockEntityMachine<T>
implements IComponent {
    public final Optional<HatchComponentHandler<T>> componentHandler;
    public final HatchMachine hatchMachine;
    private BlockBasic textureBlock = null;

    public BlockEntityHatch(final HatchMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.hatchMachine = type;
        this.componentHandler = Optional.of(new HatchComponentHandler<BlockEntityHatch>(this));
        if (type.has("fluid")) {
            this.fluidHandler.set(() -> new MachineFluidHandler<BlockEntityHatch>(this, 8000 * (this.getMachineTier().getIntegerId() + 1)));
        }
        if (type.has("eu")) {
            this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, 0L, this.getMachineTier().getVoltage() * 66L, type.getOutputCover().getId().contains("energy") ? this.tier.getVoltage() : 0L, type.getOutputCover().getId().contains("dynamo") ? this.tier.getVoltage() : 0L, type.getOutputCover().getId().contains("energy") ? 2 : 0, type.getOutputCover().getId().contains("dynamo") ? 1 : 0){

                @Override
                public boolean canInput(Direction direction) {
                    ICover out = ((BlockEntityHatch)this.tile).coverHandler.map(MachineCoverHandler::getOutputCover).orElse(null);
                    if (out == null) {
                        return false;
                    }
                    return out instanceof CoverEnergy && direction == out.side();
                }

                @Override
                protected boolean checkVoltage(long voltage) {
                    boolean flag = true;
                    if (type.getOutputCover().getId().contains("energy")) {
                        boolean bl = flag = voltage <= this.getInputVoltage();
                    }
                    if (!flag && GTLibConfig.MACHINES_EXPLODE.get()) {
                        Utils.createExplosion(((BlockEntityHatch)this.tile).m_58904_(), ((BlockEntityHatch)this.tile).m_58899_(), 4.0f, Explosion.BlockInteraction.BREAK);
                    }
                    return flag;
                }

                @Override
                public boolean canOutput(Direction direction) {
                    ICover out = ((BlockEntityHatch)this.tile).coverHandler.map(MachineCoverHandler::getOutputCover).orElse(null);
                    if (out == null) {
                        return false;
                    }
                    return out instanceof CoverDynamo && direction == out.side();
                }
            });
        }
    }

    public void setTextureBlock(BlockBasic textureBlock) {
        this.textureBlock = textureBlock;
        this.sidedSync(true);
    }

    @Override
    public boolean wrenchMachine(Player player, BlockHitResult res, boolean crouch) {
        return this.setFacing(player, Utils.getInteractSide(res));
    }

    @Override
    protected boolean setFacing(Player player, Direction side) {
        boolean setFacing = super.setFacing(player, side);
        if (setFacing) {
            this.setOutputFacing(player, side);
        }
        return setFacing;
    }

    public Optional<HatchComponentHandler<T>> getComponentHandler() {
        return this.componentHandler;
    }

    public Texture getBaseTexture(Direction side) {
        if (this.textureBlock == null || this.textureBlock.getTextures().length == 0) {
            return null;
        }
        if (this.textureBlock.getTextures().length >= 6) {
            return this.textureBlock.getTextures()[side.m_122411_()];
        }
        return this.textureBlock.getTextures()[0];
    }

    @Override
    public Function<Direction, Texture> getMultiTexture() {
        if (this.textureBlock == null || this.textureBlock.getTextures().length == 0) {
            return null;
        }
        return this::getBaseTexture;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (this.isClientSide()) {
            return;
        }
        super.onMachineEvent(event, data);
        if (event instanceof SlotType) {
            ((Collection)this.componentHandler.map(ComponentHandler::getControllers).orElse(Collections.emptyList())).forEach(controller -> {
                if (event == SlotType.IT_IN || event == SlotType.IT_OUT || event == SlotType.CELL_IN || event == SlotType.CELL_OUT || event == SlotType.FL_IN || event == SlotType.FL_OUT) {
                    controller.onMachineEvent(event, data);
                }
            });
        } else if (event instanceof MachineEvent) {
            ((Collection)this.componentHandler.map(ComponentHandler::getControllers).orElse(Collections.emptyList())).forEach(controller -> {
                switch ((MachineEvent)event) {
                    case ENERGY_DRAINED: 
                    case ENERGY_INPUTTED: 
                    case HEAT_INPUTTED: 
                    case HEAT_DRAINED: {
                        controller.onMachineEvent(event, data);
                        break;
                    }
                }
            });
        }
    }

    @Override
    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        this.coverHandler.ifPresent(t -> {
            ICover cover = t.getOutputCover();
            if (!(cover instanceof CoverOutput)) {
                return;
            }
            CoverOutput output = (CoverOutput)cover;
            output.setEjects(this.has("fluid"), this.has("item"));
        });
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (this.textureBlock != null) {
            updateTag.m_128359_("textureBlock", this.textureBlock.getLoc().toString());
        } else {
            updateTag.m_128379_("noTextureBlock", true);
        }
        return updateTag;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("textureBlock")) {
            BlockBasic blockBasic;
            Block block = GTAPI.get(Block.class, new ResourceLocation(tag.m_128461_("textureBlock")));
            this.textureBlock = block instanceof BlockBasic ? (blockBasic = (BlockBasic)block) : null;
        }
        if (tag.m_128471_("noTextureBlock")) {
            this.textureBlock = null;
        }
        if (this.f_58857_ != null) {
            this.sidedSync(true);
        }
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return new ResourceLocation(this.getMachineType().getDomain(), "textures/gui/machine/hatch.png");
    }

    @Generated
    public BlockBasic getTextureBlock() {
        return this.textureBlock;
    }
}

