/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;

public class BlockEntityTickable<T extends BlockEntityTickable<T>>
extends BlockEntityBase<T> {
    private boolean hadFirstTick;

    public BlockEntityTickable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void serverTick(Level level, BlockPos pos, BlockState state) {
    }

    protected void clientTick(Level level, BlockPos pos, BlockState state) {
    }

    protected void tick(Level level, BlockPos pos, BlockState state) {
        level.m_46473_().m_6180_("GTLibTileTick");
        if (!this.hadFirstTick) {
            if (level.m_5776_()) {
                this.onFirstTickClient(level, pos, state);
            } else {
                this.onFirstTickServer(level, pos, state);
            }
            this.hadFirstTick = true;
        }
        if (level.m_5776_()) {
            if (this.canClientTick()) {
                this.clientTick(level, pos, state);
            }
        } else {
            this.serverTick(level, pos, state);
        }
        level.m_46473_().m_7238_();
    }

    protected boolean canClientTick() {
        return false;
    }

    public static <T extends BlockEntity> void commonTick(Level level, BlockPos pos, BlockState state, T tile) {
        if (tile instanceof BlockEntityTickable) {
            BlockEntityTickable tick = (BlockEntityTickable)tile;
            tick.tick(level, pos, state);
        }
    }

    public boolean hadFirstTick() {
        return this.hadFirstTick;
    }

    public void onFirstTick() {
    }

    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
    }

    public void onFirstTickClient(Level level, BlockPos pos, BlockState state) {
    }

    @Override
    public void onRemove() {
        super.onRemove();
    }
}

