/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.texture.Texture;

public class BlockStone
extends BlockBasic
implements ISharedGTObject {
    protected StoneType type;
    protected String suffix;

    public BlockStone(StoneType type) {
        super(type.getDomain(), type.getId(), BlockStone.getProps(type));
        this.type = type;
        this.suffix = "";
    }

    public BlockStone(StoneType type, String suffix) {
        super(type.getDomain(), type.getId() + "_" + suffix, BlockStone.getProps(type).m_60922_(BlockStone::notValidSpawn));
        this.type = type;
        this.suffix = suffix;
    }

    private static BlockBehaviour.Properties getProps(StoneType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)type.getBlockMaterial()).m_60918_(type.getSoundType()).m_60913_(type.getHardness(), type.getResistence());
        if (type.doesRequireTool()) {
            props.m_60999_();
        }
        return props;
    }

    static boolean notValidSpawn(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, EntityType<?> object) {
        return false;
    }

    public StoneType getType() {
        return this.type;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public Texture[] getTextures() {
        StoneType stoneType = this.type;
        if (stoneType instanceof CobbleStoneType) {
            CobbleStoneType c = (CobbleStoneType)stoneType;
            if (!this.suffix.isEmpty()) {
                return new Texture[]{new Texture(this.type.getDomain(), c.getBeginningPath() + this.type.getId() + "/" + this.suffix)};
            }
        }
        return this.type.getTextures();
    }
}

