/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.worldgen;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.gtreimagined.gt5r.worldgen.OilSpoutEntry;
import org.gtreimagined.gt5r.worldgen.OilSpoutFluid;
import org.gtreimagined.gtlib.util.XSTR;

public class OilSpoutSavedData
extends SavedData {
    private static Map<String, OilSpoutFluid> FLUID_MAP = new Object2ObjectOpenHashMap();
    public static final int VEIN_CHUNK_SIZE = 6;
    public static final int MAXIMUM_VEIN_OPERATIONS = 100000;
    public final HashMap<ChunkPos, OilSpoutEntry> veinFluids = new HashMap();
    private final ServerLevel serverLevel;

    public static OilSpoutSavedData getOrCreate(ServerLevel serverLevel) {
        DimensionDataStorage dataStorage = serverLevel.m_8895_();
        OilSpoutSavedData data = (OilSpoutSavedData)dataStorage.m_164858_(tag -> new OilSpoutSavedData(serverLevel, (CompoundTag)tag), "gti_oil_sprouts");
        if (data != null) {
            dataStorage.m_164855_("gt5r_oil_sprouts", (SavedData)data);
            dataStorage.m_164855_("gti_oil_sprouts", null);
            return data;
        }
        return (OilSpoutSavedData)serverLevel.m_8895_().m_164861_(tag -> new OilSpoutSavedData(serverLevel, (CompoundTag)tag), () -> new OilSpoutSavedData(serverLevel), "gt5r_oil_spouts");
    }

    public OilSpoutSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public OilSpoutSavedData(ServerLevel serverLevel, CompoundTag nbt) {
        this(serverLevel);
        ListTag list = nbt.m_128437_("oilSpout", 10);
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)tag;
            ChunkPos chunkPos = new ChunkPos(compoundTag.m_128454_("p"));
            this.veinFluids.put(chunkPos, OilSpoutEntry.readFromNBT(compoundTag.m_128469_("d")));
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag oilList = new ListTag();
        for (Map.Entry<ChunkPos, OilSpoutEntry> entry : this.veinFluids.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("p", entry.getKey().m_45588_());
            tag.m_128365_("d", (Tag)entry.getValue().writeToNBT());
            oilList.add((Object)tag);
        }
        compoundTag.m_128365_("oilSpout", (Tag)oilList);
        return compoundTag;
    }

    public OilSpoutEntry getFluidVeinWorldEntry(int chunkX, int chunkZ) {
        if (!this.veinFluids.containsKey(new ChunkPos(chunkX, chunkZ))) {
            Object random = new XSTR(this.serverLevel.m_7328_() + (long)((int)Math.floor((double)chunkX / 6.0)) + (long)(7 * (int)Math.floor((double)chunkZ / 6.0)));
            OilSpoutFluid fluid = this.getRandomFluid((Random)random);
            random = this.serverLevel.f_46441_;
            int maximumYield = 0;
            if (fluid != null) {
                maximumYield = fluid.getMaxYield() - fluid.getMinYield() <= 0 ? fluid.getMinYield() : ((Random)random).nextInt(fluid.getMaxYield() - fluid.getMinYield()) + fluid.getMinYield();
                maximumYield = Math.min(maximumYield, fluid.getMaxYield());
            }
            this.veinFluids.put(new ChunkPos(chunkX, chunkZ), new OilSpoutEntry(fluid, maximumYield));
        }
        this.m_77762_();
        return this.veinFluids.get(new ChunkPos(chunkX, chunkZ));
    }

    public OilSpoutFluid getRandomFluid(Random aRandom) {
        int random = aRandom.nextInt(1000);
        for (OilSpoutFluid fl : FLUID_MAP.values()) {
            int chance = fl.chance() * 1000 / OilSpoutFluid.getTotalWeight();
            if (random <= chance) {
                return fl;
            }
            random -= chance;
        }
        return null;
    }

    public static void clearFluidMap() {
        FLUID_MAP.clear();
    }

    public static void registerOilSpoutFluid(String id, OilSpoutFluid fluid) {
        FLUID_MAP.put(id, fluid);
    }

    public static OilSpoutFluid getOilSpoutFluid(String fluidId) {
        if (fluidId.equals("medium_oil")) {
            fluidId = "oil";
        }
        return FLUID_MAP.get(fluidId);
    }
}

