/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine.recipe;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.data.GT5RRecipeTypes;
import org.gtreimagined.gt5r.machine.recipe.FusionRecipe;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.serializer.GTRecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionRecipeSerializer
extends GTRecipeSerializer<FusionRecipe> {
    public static final FusionRecipeSerializer INSTANCE = new FusionRecipeSerializer();

    public static void init() {
    }

    protected FusionRecipeSerializer() {
        super("gt5r", "fusion");
    }

    public RecipeType<FusionRecipe> getRecipeType() {
        return GT5RRecipeTypes.FUSION_RECIPE;
    }

    public FusionRecipe createRecipe(@NotNull List<Ingredient> stacksInput, ItemStack[] stacksOutput, @NotNull List<FluidIngredient> fluidsInput, FluidStack[] fluidsOutput, int duration, long power, int special, int amps) {
        return new FusionRecipe(stacksInput, stacksOutput, fluidsInput, fluidsOutput, duration, power, special, amps);
    }

    public void toJson(JsonObject json, IRecipe recipe) {
        super.toJson(json, recipe);
        if (recipe instanceof FusionRecipe) {
            FusionRecipe fusionRecipe = (FusionRecipe)recipe;
            json.addProperty("huOutput", (Number)fusionRecipe.getHuOutput());
        }
    }

    public FusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        FusionRecipe fusionRecipe = (FusionRecipe)super.fromJson(recipeId, json);
        if (fusionRecipe != null && json.has("huOutput")) {
            fusionRecipe.setHuOutput(json.get("huOutput").getAsInt());
        }
        return fusionRecipe;
    }

    @Nullable
    public FusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        FusionRecipe fusionRecipe = (FusionRecipe)super.fromNetwork(recipeId, buffer);
        if (fusionRecipe != null) {
            fusionRecipe.setHuOutput(buffer.readInt());
        }
        return fusionRecipe;
    }

    public void toNetwork(FriendlyByteBuf buffer, FusionRecipe recipe) {
        super.toNetwork(buffer, (IRecipe)recipe);
        buffer.writeInt(recipe.getHuOutput());
    }
}

