/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.multi;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.integration.tfc.TFCRegistrar;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.RecipeBuilders;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;

public class BlastFurnaceLoader {
    public static void init() {
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(TFCRegistrar.getIron(), 1)}).io(new ItemStack[]{GTMaterialTypes.INGOT.get(Materials.Steel, 1), GTMaterialTypes.SMALL_DUST.get(Materials.DarkAsh, 8)}).outputChances(new double[]{1.0, 0.5}).add("steel_ingot", 7200L, 0L);
        GTMaterialTypes.DUST.all().forEach(m -> {
            if (m.has(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE}) && m.has(new IMaterialTag[]{GT5RMaterialTags.BLAST_FURNACE_TEMP})) {
                ItemStack ingot = MaterialTags.DIRECT_SMELT_INTO.getMapping(m).has(new IMaterialTag[]{GTMaterialTypes.HOT_INGOT}) ? GTMaterialTypes.HOT_INGOT.get(MaterialTags.DIRECT_SMELT_INTO.getMapping(m), 1) : GTMaterialTypes.INGOT.get(MaterialTags.DIRECT_SMELT_INTO.getMapping(m), 1);
                int heat = GT5RMaterialTags.BLAST_FURNACE_TEMP.getInt(m);
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(heat).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(m, 1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{ingot}).add(MaterialTags.DIRECT_SMELT_INTO.getMapping(m).getId() + "_ingot_from_" + m.getId() + "_dust", Math.max(m.getMass() / 40L, 1L) * (long)heat, 120L);
            }
        });
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.BlackSteel, 1)}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.BlackSteel)}).add("black_steel", 10800L);
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.BlueSteel, 1)}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.BlueSteel)}).add("blue_steel", 14400L);
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.RedSteel, 1)}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.RedSteel)}).add("red_steel", 14400L);
        Material iron = TFCRegistrar.getIron();
        BlastFurnaceLoader.addCalciteRecipe(Materials.Hematite, 4, GTMaterialTypes.INGOT.get(iron, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.YellowLimonite, 6, GTMaterialTypes.INGOT.get(iron, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.BrownLimonite, 6, GTMaterialTypes.INGOT.get(iron, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Magnetite, 11, GTMaterialTypes.INGOT.get(iron, 3));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Chalcopyrite, 6, GTMaterialTypes.INGOT.get(Materials.Copper, 1), GTMaterialTypes.INGOT.get(iron, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Galena, 4, GTMaterialTypes.INGOT.get(Materials.Lead, 1), GTMaterialTypes.INGOT.get(Materials.Silver, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Garnierite, 1, GTMaterialTypes.INGOT.get(Materials.Nickel, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Cassiterite, 1, GTMaterialTypes.INGOT.get(Materials.Tin, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Cobaltite, 5, GTMaterialTypes.INGOT.get(Materials.Cobalt, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Pyrite, 4, GTMaterialTypes.INGOT.get(iron, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Stibnite, 4, GTMaterialTypes.INGOT.get(Materials.Antimony, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Tetrahedrite, 12, GTMaterialTypes.INGOT.get(Materials.Copper, 3), GTMaterialTypes.INGOT.get(Materials.Antimony, 1), GTMaterialTypes.INGOT.get(iron, 1));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Malachite, 15, GTMaterialTypes.INGOT.get(Materials.Copper, 2));
        BlastFurnaceLoader.addCalciteRecipe(Materials.Pentlandite, 11, GTMaterialTypes.INGOT.get(Materials.Nickel, 4));
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1200).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Copper, 1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.AnnealedCopper)}).add("annealed_copper_ingot", 500L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1000).ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(Materials.Iron, 1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.Steel), GTMaterialTypes.SMALL_DUST.get(Materials.DarkAsh)}).add("steel_ingot", 500L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1000).ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(Materials.WroughtIron, 1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.Steel), GTMaterialTypes.SMALL_DUST.get(Materials.DarkAsh)}).add("steel_ingot_2", 100L, 120L);
        if (!GT5RConfig.HARDER_ALUMINIUM_PROCESSING.get()) {
            ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1200).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Ruby, 1)}).io(new ItemStack[]{GTMaterialTypes.NUGGET.get(Materials.Aluminium, 3), GTMaterialTypes.TINY_DUST.get(Materials.DarkAsh, 1)}).add("aluminium_ingot_from_ruby", 400L, 100L);
            ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1200).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Sapphire, 1)}).io(new ItemStack[]{GTMaterialTypes.NUGGET.get(Materials.Aluminium, 3)}).add("aluminium_ingot_from_blue_sapphire", 400L, 100L);
            ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1200).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.GreenSapphire, 1)}).io(new ItemStack[]{GTMaterialTypes.NUGGET.get(Materials.Aluminium, 3), GTMaterialTypes.TINY_DUST.get(Materials.DarkAsh, 1)}).add("aluminium_ingot_from_green_sapphire", 400L, 100L);
            int heat = GT5RMaterialTags.BLAST_FURNACE_TEMP.getInt(Materials.Aluminium);
            ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1700).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Aluminium, 1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.Aluminium)}).add("aluminium_ingot_from_aluminium_dust", Math.max(Materials.Aluminium.getMass() / 40L, 1L) * (long)heat, 120L);
            ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(1700).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Alumina, 4), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Calcite), GTMaterialTypes.DUST.getMaterialTag(Materials.Limestone), GTMaterialTypes.DUST.getMaterialTag(Materials.Marble)})}).io(new Item[]{GTMaterialTypes.INGOT.get(Materials.Aluminium)}).add("alumina", 400L, 120L);
        }
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.StainlessSteel, 9, 1000, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Iron, (Object)6, (Object)Materials.Nickel, (Object)1, (Object)Materials.Manganese, (Object)1, (Object)Materials.Chromium, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.TungstenSteel, 2, 3000, 480, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Steel, (Object)1, (Object)Materials.Tungsten, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.TungstenCarbide, 1, 4920, 480, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Carbon, (Object)1, (Object)Materials.Tungsten, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.TitaniumGold, 4, 2000, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Titanium, (Object)3, (Object)Materials.Gold, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.NiobiumTitanium, 2, 4500, 480, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Niobium, (Object)1, (Object)Materials.Titanium, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.VanadiumGallium, 4, 4500, 480, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Vanadium, (Object)3, (Object)Materials.Gallium, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.VanadiumSteel, 9, 4500, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Vanadium, (Object)1, (Object)Materials.Chromium, (Object)1, (Object)Materials.Steel, (Object)7));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.Ultimet, 9, 2700, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Cobalt, (Object)5, (Object)Materials.Chromium, (Object)2, (Object)Materials.Nickel, (Object)1, (Object)Materials.Molybdenum, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.Kanthal, 3, 1800, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Iron, (Object)1, (Object)Materials.Aluminium, (Object)1, (Object)Materials.Chromium, (Object)1));
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(2700).ii(new Ingredient[]{RecipeIngredient.of((int)4, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Nickel), GTMaterialTypes.INGOT.getMaterialTag(Materials.Nickel)}), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Chromium), GTMaterialTypes.INGOT.getMaterialTag(Materials.Chromium)}), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new ItemStack[]{GTMaterialTypes.HOT_INGOT.get(Materials.Nichrome, 5)}).add("nichrome_ingot", 2700L, 480L);
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.Trinitanium, 3, 2410, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Trinium, (Object)2, (Object)Materials.Titanium, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.TritaniumAlloy, 4, 1800, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Tritanium, (Object)3, (Object)Materials.Duranium, (Object)1));
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(2900).ii(new Ingredient[]{RecipeIngredient.of((int)3, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Iridium), GTMaterialTypes.INGOT.getMaterialTag(Materials.Iridium)}), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Osmium), GTMaterialTypes.INGOT.getMaterialTag(Materials.Osmium)})}).fi(new FluidStack[]{Materials.Helium.getGas(1000)}).io(new ItemStack[]{GTMaterialTypes.HOT_INGOT.get(Materials.Osmiridium, 4)}).add("osmiridium_ingot", 500L, 1920L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(7200).ii(new Ingredient[]{RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Naquadah), GTMaterialTypes.INGOT.getMaterialTag(Materials.Naquadah)}), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.INGOT.getMaterialTag(Materials.Osmiridium), GTMaterialTypes.DUST.getMaterialTag(Materials.Osmiridium), GTMaterialTypes.HOT_INGOT.getMaterialTag(Materials.Osmiridium)})}).fi(new FluidStack[]{Materials.Argon.getGas(1000)}).io(new ItemStack[]{GTMaterialTypes.HOT_INGOT.get(Materials.NaquadahAlloy, 2)}).add("naquadah_alloy_ingot", 500L, 30720L);
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.BlackSteel, 5, 1200, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Nickel, (Object)1, (Object)Materials.BlackBronze, (Object)1, (Object)Materials.Steel, (Object)3));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.BlueSteel, 8, 1400, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.SterlingSilver, (Object)1, (Object)Materials.BismuthBronze, (Object)1, (Object)Materials.Steel, (Object)2, (Object)Materials.BlackSteel, (Object)4));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.RedSteel, 8, 1300, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.RoseGold, (Object)1, (Object)Materials.Brass, (Object)1, (Object)Materials.Steel, (Object)2, (Object)Materials.BlackSteel, (Object)4));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.HSSG, 9, 9000, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.TungstenSteel, (Object)5, (Object)Materials.Chromium, (Object)1, (Object)Materials.Molybdenum, (Object)2, (Object)Materials.Vanadium, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.HSSE, 9, 10800, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.HSSG, (Object)6, (Object)Materials.Cobalt, (Object)1, (Object)Materials.Manganese, (Object)1, (Object)Materials.Silicon, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.HSSS, 9, 16200, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.HSSG, (Object)6, (Object)Materials.Iridium, (Object)2, (Object)Materials.Osmium, (Object)1));
        BlastFurnaceLoader.addBlastAlloyRecipes(Materials.YttriumBariumCuprate, 6, 4500, 120, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)3, (Object)Materials.Barium, (Object)2, (Object)Materials.Yttrium, (Object)1));
    }

    public static void addBlastAlloyRecipes(Material output, int amount, int duration, int power, ImmutableMap<Material, Integer> inputs) {
        RecipeBuilders.BlastingBuilder b = ((RecipeBuilders.BlastingBuilder)RecipeMaps.E_BLAST_FURNACE.RB()).temperature(GT5RMaterialTags.BLAST_FURNACE_TEMP.getInt(output));
        b.io(new ItemStack[]{(output.has(new IMaterialTag[]{GTMaterialTypes.HOT_INGOT}) ? GTMaterialTypes.HOT_INGOT : GTMaterialTypes.INGOT).get(output, amount)});
        inputs.forEach((arg_0, arg_1) -> BlastFurnaceLoader.lambda$addBlastAlloyRecipes$1((RecipeBuilder)b, arg_0, arg_1));
        b.add(output.getId() + "_ingot", (long)duration, (long)power);
    }

    private static void addCalciteRecipe(Material ore, int input, ItemStack ... outputs) {
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.RAW_ORE.getMaterialIngredient(ore, input), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Calcite), GTMaterialTypes.DUST.getMaterialTag(Materials.Limestone), GTMaterialTypes.DUST.getMaterialTag(Materials.Marble)})}).io(outputs).add(ore.getId(), (long)Arrays.stream(outputs).mapToInt(ItemStack::m_41613_).sum() * 500L);
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.CRUSHED_ORE.getMaterialIngredient(ore, input), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Calcite), GTMaterialTypes.DUST.getMaterialTag(Materials.Limestone), GTMaterialTypes.DUST.getMaterialTag(Materials.Marble)})}).io(outputs).add("crushed_" + ore.getId(), (long)Arrays.stream(outputs).mapToInt(ItemStack::m_41613_).sum() * 500L);
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.IMPURE_DUST.getMaterialIngredient(ore, input), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Calcite), GTMaterialTypes.DUST.getMaterialTag(Materials.Limestone), GTMaterialTypes.DUST.getMaterialTag(Materials.Marble)})}).io(outputs).add("impure_" + ore.getId(), (long)Arrays.stream(outputs).mapToInt(ItemStack::m_41613_).sum() * 500L);
        RecipeMaps.PRIMITIVE_BLAST_FURNACE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(ore, input), RecipeIngredient.of((int)1, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Calcite), GTMaterialTypes.DUST.getMaterialTag(Materials.Limestone), GTMaterialTypes.DUST.getMaterialTag(Materials.Marble)})}).io(outputs).add("dust_" + ore.getId(), (long)Arrays.stream(outputs).mapToInt(ItemStack::m_41613_).sum() * 500L);
    }

    private static /* synthetic */ void lambda$addBlastAlloyRecipes$1(RecipeBuilder b, Material m, Integer i) {
        if (m.has(new IMaterialTag[]{GTMaterialTypes.HOT_INGOT})) {
            b.ii(new Ingredient[]{RecipeIngredient.of((int)i, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(m), GTMaterialTypes.INGOT.getMaterialTag(m), GTMaterialTypes.HOT_INGOT.getMaterialTag(m)})});
        } else if (m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
            b.ii(new Ingredient[]{RecipeIngredient.of((int)i, (TagKey[])new TagKey[]{GTMaterialTypes.DUST.getMaterialTag(m), GTMaterialTypes.INGOT.getMaterialTag(m)})});
        } else {
            b.ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(m, i.intValue())});
        }
    }
}

