/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class FluidSolidifierLoader {
    public static void init() {
        GTAPI.all(Material.class, mat -> {
            Material outMat;
            if (!mat.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) || mat == Materials.Glass) {
                return;
            }
            Material material = outMat = mat == Materials.Iron && GTAPI.isModLoaded((String)"tfc") ? Materials.CastIron : mat;
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.PlateMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(144)}).io(new ItemStack[]{GTMaterialTypes.PLATE.get(outMat, 1)}).add(outMat.getId() + "_plate", 32L, 8L);
            }
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.ITEM_CASING})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.CasingMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(72)}).io(new ItemStack[]{GTMaterialTypes.ITEM_CASING.get(outMat, 1)}).add(outMat.getId() + "_casing", 16L, 8L);
            }
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.IngotMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(mat == Materials.Alumina ? 504 : 144)}).io(new ItemStack[]{GTMaterialTypes.INGOT.get(outMat, 1)}).add(outMat.getId() + "_ingot", 32L, 8L);
            }
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.GEAR})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.GearMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(576)}).io(new ItemStack[]{GTMaterialTypes.GEAR.get(outMat, 1)}).add(outMat.getId() + "_gear", 128L, 8L);
            }
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.SMALL_GEAR})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.SmallGearMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(144)}).io(new ItemStack[]{GTMaterialTypes.SMALL_GEAR.get(outMat, 1)}).add(outMat.getId() + "_gear_small", 16L, 8L);
            }
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.NUGGET})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.NuggetMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(mat == Materials.Alumina ? 56 : 16)}).io(new ItemStack[]{GTMaterialTypes.NUGGET.get(outMat, 1)}).add(outMat.getId() + "_nugget", 16L, 4L);
            }
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.LONG_ROD})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.LongRodMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(144)}).io(new ItemStack[]{GTMaterialTypes.LONG_ROD.get(outMat, 1)}).add(outMat.getId() + "_long_rod", 16L, 8L);
            }
            if (outMat.has(new IMaterialTag[]{GTMaterialTypes.BLOCK})) {
                RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BlockMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{mat.getFluidIngredient(mat == Materials.Alumina ? 4536 : 1296)}).io(new ItemStack[]{((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.BLOCK.get()).get(outMat).asStack(1)}).add(outMat.getId() + "_block", 288L, 8L);
            }
        });
        for (DyeColor dye : DyeColor.values()) {
            Material concrete = Material.get((String)(dye.m_41065_() + "_concrete"));
            RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BlockMold, (int)1).setNoConsume()}).fi(new FluidStack[]{concrete.getLiquid(144)}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_concrete"))}).add(dye.m_41065_() + "_concrete", 288L, 8L);
        }
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.LongRodMold, (int)1).setNoConsume()}).fi(new FluidStack[]{Materials.Lava.getLiquid(111)}).io(new Item[]{GTMaterialTypes.LONG_ROD.get(Materials.Obsidian)}).add("long_obsidian_rod", 16L, 8L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.PlateMold, (int)1).setNoConsume()}).fi(new FluidStack[]{Materials.Lava.getLiquid(111)}).io(new Item[]{GTMaterialTypes.PLATE.get(Materials.Obsidian)}).add("obsidian_plate", 16L, 8L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BlockMold, (int)1).setNoConsume()}).fi(new FluidStack[]{Materials.Lava.getLiquid(1000)}).io(new Item[]{Items.f_41999_}).add("obsidian", 16L, 8L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.PlateMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{Materials.Glass.getFluidIngredient(144)}).io(new Item[]{GTMaterialTypes.PLATE.get(Materials.Glass)}).add("glass_plate", 12L, 4L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BlockMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{Materials.Glass.getFluidIngredient(144)}).io(new Item[]{Items.f_41904_}).add("glass_block", 12L, 4L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BottleMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{Materials.Glass.getFluidIngredient(144)}).io(new Item[]{Items.f_42590_}).add("glass_bottle", 12L, 4L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BlockMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{Materials.Glowstone.getFluidIngredient(576)}).io(new Item[]{Items.f_42054_}).add("glowstone_block", 12L, 4L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BlockMold, (int)1).setNoConsume()}).fi(new FluidStack[]{Materials.Water.getLiquid(1000)}).io(new Item[]{Items.f_41981_}).add("snow_block", 512L, 4L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BlockMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{Materials.DistilledWater.getFluidIngredient(1000)}).io(new Item[]{Items.f_41981_}).add("snow_block_2", 512L, 4L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BallMold, (int)1).setNoConsume()}).fi(new FluidStack[]{Materials.Water.getLiquid(250)}).io(new Item[]{Items.f_42452_}).add("snow_ball", 128L, 4L);
        RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.BallMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{Materials.DistilledWater.getFluidIngredient(250)}).io(new Item[]{Items.f_42452_}).add("snow_ball_2", 128L, 4L);
        if (!GTAPI.isModLoaded((String)"tfc")) {
            RecipeMaps.FLUID_SOLIDIFYER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.AnvilMold, (int)1).setNoConsume()}).fi(new FluidIngredient[]{Materials.Iron.getFluidIngredient(4464)}).io(new Item[]{Items.f_42146_}).add("anvil", 128L, 16L);
        }
    }
}

